% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readPed.R
\name{readPed}
\alias{readPed}
\title{Read a pedigree from file}
\usage{
readPed(
  pedfile,
  header = NA,
  famid_col = NA,
  id_col = NA,
  fid_col = NA,
  mid_col = NA,
  sex_col = NA,
  marker_col = NA,
  locusAttributes = NULL,
  missing = 0,
  sep = NULL,
  validate = TRUE,
  ...
)
}
\arguments{
\item{pedfile}{A file name}

\item{header}{A logical. If NA, the program will interpret the first line as
a header line if the first entry contains "id" AND the word "sex" is an
entry.}

\item{famid_col}{Index of family ID column. If NA, the program looks for a
column named "famid" (ignoring case).}

\item{id_col}{Index of individual ID column. If NA, the program looks for a
column named "id" (ignoring case).}

\item{fid_col}{Index of father ID column. If NA, the program looks for a
column named "fid" (ignoring case).}

\item{mid_col}{Index of mother ID column. If NA, the program looks for a
column named "mid" (ignoring case).}

\item{sex_col}{Index of column with gender codes (0 = unknown; 1 = male; 2 =
female). If NA, the program looks for a column named "sex" (ignoring case).
If this is not found, genders of parents are deduced from the data, leaving
the remaining as unknown.}

\item{marker_col}{Index vector indicating columns with marker alleles. If NA,
all columns to the right of all pedigree columns are used. If \code{sep}
(see below) is non-NULL, each column is interpreted as a genotype column
and split into separate alleles with \code{strsplit(..., split = sep, fixed = TRUE)}.}

\item{locusAttributes}{Passed on to \code{\link[=setMarkers]{setMarkers()}} (see explanation there).}

\item{missing}{Passed on to \code{\link[=setMarkers]{setMarkers()}} (see explanation there).}

\item{sep}{Passed on to \code{\link[=setMarkers]{setMarkers()}} (see explanation there).}

\item{validate}{A logical indicating if the pedigree structure should be validated.}

\item{...}{Further parameters passed on to \code{\link[=read.table]{read.table()}}, e.g. \code{sep},
\code{comment.char} and \code{quote}.}
}
\value{
A \link{ped} object or a list of such.
}
\description{
Read a pedigree from file
}
\examples{

tf = tempfile()

### Write and read a trio
trio = data.frame(id = 1:3, fid = c(0,0,1), mid = c(0,0,2), sex = c(1,2,1))
write.table(trio, file = tf, row.names = FALSE)
readPed(tf)

# With marker data in one column
trio.marker = cbind(trio, M = c("1/1", "2/2", "1/2"))
write.table(trio.marker, file = tf, row.names = FALSE)
readPed(tf)

# With marker data in two allele columns
trio.marker2 = cbind(trio, M.1 = c(1,2,1), M.2 = c(1,2,2))
write.table(trio.marker2, file = tf, row.names = FALSE)
readPed(tf)

### Two singletons in the same file
singles = data.frame(id = c("S1", "S2"),
                     fid = c(0,0), mid = c(0,0), sex = c(2,1),
                     M = c("9/14.2", "9/9"))
write.table(singles, file = tf, row.names = FALSE)
readPed(tf)

### Two trios in the same file
trio2 = cbind(famid = rep(c("trio1", "trio2"), each = 3), rbind(trio, trio))

# Without column names
write.table(trio2, file = tf, row.names = FALSE)
readPed(tf)

# With column names
write.table(trio2, file = tf, col.names = FALSE, row.names = FALSE)
readPed(tf, famid = 1, id = 2, fid = 3, mid = 4, sex = 5)

# Cleanup
unlink(tf)

}
