% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_utils.R
\name{harmoniseMarkers}
\alias{harmoniseMarkers}
\title{Harmonise markers across components in a ped list}
\usage{
harmoniseMarkers(x)
}
\arguments{
\item{x}{A list of \code{ped} objects. An error is raised if any component
contains an unnamed marker.}
}
\value{
A copy of \code{x} where all components have the same markers attached,
and in the same order. Unnamed markers are removed.
}
\description{
This function ensures that all components of a ped list have the same
markers, in the same order. Missing markers are added with empty genotypes.
Note that \emph{unnamed} markers cannot be harmonised and will be removed by this
function.
}
\examples{
x = list(
  singleton(1) |> addMarker(),  # unnamed marker will be removed
  singleton(2) |> addMarker(name = "M1"),
  singleton(3) |> addMarker(geno = "3/3", alleles = 1:3, name = "M2")
)
harmoniseMarkers(x)

}
