% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_PP_region.R
\name{reconsPPregion}
\alias{reconsPPregion}
\title{Reconstruct perfect phylogeny sequencce across a region}
\usage{
reconsPPregion(hapMat, minWindow)
}
\arguments{
\item{hapMat}{A data structure of class \code{hapMat}. See the arguments in \code{\link{reconstructPP}}.}

\item{minWindow}{Minimum number of SNVs around the focal SNV in the window of SNVs used to
reconstruct the perfect phylogeny.}
}
\value{
An object of class \code{multiPhylo} that contains multiple \code{phylo} objects.
}
\description{
This function reconstructs perfect phylogenies on each possible focal SNV across a genomic region.
}
\examples{
  
data(ex_hapMatSmall_data)   
                   
# Reconstruct partitions across the region of ex_hapMatSmall_data.
rdends <- reconsPPregion(hapMat = ex_hapMatSmall_data,
                      minWindow = 1)


}
