% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_model.R
\name{check_model}
\alias{check_model}
\alias{check_model.default}
\title{Visual check of model assumptions}
\usage{
check_model(x, ...)

\method{check_model}{default}(x, dot_size = 2, line_size = 0.8,
  panel = TRUE, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}

\item{dot_size}{Size of dot-geoms.}

\item{line_size}{Size of line-geoms.}

\item{panel}{Logical, if \code{TRUE}, plots are arranged as panels; else,
single plots for each diagnostic are returned.}
}
\value{
The data frame that is used for plotting.
}
\description{
Visual check of model various assumptions (normality of residuals,
normality of random effects, heteroscedasticity, homogeneity of variance,
multicollinearity).
}
\note{
This function just prepares the data for plotting. To create the plots,
\CRANpkg{see} needs to be installed.
}
\examples{
\dontrun{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_model(m)

library(lme4)
m <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
check_model(m, panel = FALSE)

library(rstanarm)
m <- stan_glm(mpg ~ wt + gear, data = mtcars, chains = 2, iter = 200)
check_model(m)
}

}
