% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_normality.R
\name{check_normality}
\alias{check_normality}
\title{Check model for (non-)normality of residuals.}
\usage{
check_normality(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}
}
\value{
Invisibly returns the p-value of the test statistics. A p-value
< 0.05 indicates a significant deviation from normal distribution
}
\description{
Check model for (non-)normality of residuals.
}
\details{
\code{check_normality()} calls \code{\link[stats]{shapiro.test}}
and checks the standardized residuals for normal distribution. Note that
this formal test almost always yields significant results for the distribution
of residuals and visual inspection (e.g. Q-Q plots) are preferable.
}
\examples{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_normality(m)

}
