% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_footer}
\alias{add_ui_footer}
\title{Add UI elements to dashboard footer section}
\usage{
add_ui_footer(left = NULL, right = NULL, fixed = FALSE)
}
\arguments{
\item{left}{- Left side UI elements}

\item{right}{- Right side UI elements}

\item{fixed}{- Always show footer at page bottom regardless page scroll location (default = FALSE).}
}
\value{
list of both shiny UI elements and named footer properties
}
\description{
Builds application footer with given configurations and elements. It is called within "ui_footer.R".
Check example application for detailed example
}
\section{Shiny Usage}{

Call this function from \code{program/ui_footer.R} to set footer parameters
}

\examples{
  library(shiny)
  library(bs4Dash)

  # Inside ui_footer.R
  # Left text
  left <- a(href   = "https://periscopeapps.org/",
            target = "_blank",
            "periscope2")
  # Right text
  right <- "2022"

  # -- Register Elements in the ORDER SHOWN in the UI
  add_ui_footer(left, right)

}
\seealso{
\link[bs4Dash:bs4DashFooter]{bs4Dash:bs4DashFooter()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:set_app_parameters]{periscope2:set_app_parameters()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
