% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_right_sidebar}
\alias{add_ui_right_sidebar}
\title{Add UI elements to dashboard right sidebar section}
\usage{
add_ui_right_sidebar(
  sidebar_elements = NULL,
  sidebar_menu = NULL,
  collapsed = TRUE,
  overlay = TRUE,
  pinned = FALSE,
  skin = "light"
)
}
\arguments{
\item{sidebar_elements}{- List of regular shiny UI elements (inputText, textArea, etc..)}

\item{sidebar_menu}{- \code{?bs4Dash::controlbarMenu()} object to created a menu inside right sidebar}

\item{collapsed}{- If TRUE, the sidebar will be collapsed on app startup (default = TRUE)}

\item{overlay}{- Whether the sidebar covers the content when expanded (default = TRUE)}

\item{pinned}{- If TRUE, allows right sidebar to remain open even after a click outside (default = FALSE)}

\item{skin}{- Sidebar skin. "dark" or "light" (default = "light")}
}
\value{
list of both shiny UI elements and named right sidebar properties
}
\description{
Builds application right sidebar with given configurations and elements. It is called within "ui_right_sidebar.R".
Check example application for detailed example
}
\section{Shiny Usage}{

Call this function from \code{program/ui_right_sidebar.R} to set right sidebar parameters
}

\examples{
  library(shiny)
  library(bs4Dash)

  # Inside ui_right_sidebar.R
  sidebar_elements <- list(div(checkboxInput("checkMe", "Example Check")))
  sidebar_menu     <- controlbarMenu(id = "controlbarmenu",
                                     controlbarItem("Item 2", "Simple text"))
 # -- Register Right Sidebar Elements in the ORDER SHOWN in the UI
  add_ui_right_sidebar(sidebar_elements = sidebar_elements,
                       sidebar_menu     = sidebar_menu)

}
\seealso{
\link[bs4Dash:bs4DashControlbar]{bs4Dash:bs4DashControlbar()}

\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:set_app_parameters]{periscope2:set_app_parameters()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
