% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/personograph.R
\name{uplift}
\alias{uplift}
\title{"Uplift" from IER and CER}
\usage{
uplift(ier, cer, higher_is_better = NULL)
}
\arguments{
\item{ier}{Intervention Event Rates}

\item{cer}{Control Event Rates}

\item{higher_is_better}{logical indicating the direction of the outcome measure, default TRUE}
}
\value{
A list of S3 class \code{personograph.uplift} with the following elements:
\itemize{
\item{\code{good outcome}} {people who have a good outcome regardless of intervention}
\item{\code{bad outcome}} {people who have a bad outcome regradless of intervention}
\item{\code{intervention benefit}} {people who benefit from intervention}
\item{\code{intervention harm}} {people who are harmed by intervention}
}

Can be plotted as a personograph with the S3 generic \code{plot}.
}
\description{
Calculates the percentage (from 0 to 1) of people who have an intervention benefit, intervention harm, bad outcome regardless, and good outcome regardless
from the Intervention Event Rates (IER) and Control Event Rates (CER).
Note that the result depends on the direction of the outcome measure,
e.g. \code{higher_is_better = T} (default) for intervention efficacy, \code{higher_is_better = F} for
adverse events.
}
\details{
The adopted terminology is similar to that of Uplift modelling
\url{https://en.wikipedia.org/wiki/Uplift_modelling}
}
\examples{
ier <- 0.06368133
cer <- 0.1115242
u <- uplift(ier, cer, higher_is_better=TRUE)
plot(u)
}

