% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_match.R
\name{is_threatened_peru}
\alias{is_threatened_peru}
\title{Check if species are threatened listed in DS 043-2006-AG Peru}
\usage{
is_threatened_peru(splist, source = "original", return_details = FALSE)
}
\arguments{
\item{splist}{A character vector containing the list of species names to be
checked for threatened status in Peru.}

\item{source}{Character string specifying which database version to use.
Options are:
\itemize{
  \item \code{"original"} (default): Uses the original threatened species database
  \item \code{"updated"}: Uses the updated database with synonyms
}}

\item{return_details}{Logical. If TRUE, returns detailed matching results.
If FALSE (default), returns only the threat status vector.}
}
\value{
If return_details = FALSE: A character vector indicating the threat
status of each species ("Not threatened", "Threatened - CR", "Threatened - EN",
"Threatened - VU", "Threatened - NT", or "Threatened - Unknown category").

If return_details = TRUE: A tibble with detailed matching results including
matched names, threat categories, and matching process information.
}
\description{
This function checks if a list of species names are threatened according to the
Peruvian threatened species database. The function allows fuzzy matching for
species names with a maximum distance threshold to handle potential typos or
variations in species names.
}
\examples{
\donttest{
# Example 1: Basic usage with valid species names
species_list <- c("Cattleya maxima", "Polylepis incana", "Fake species")

# Simple status check
threat_status <- tryCatch(
  is_threatened_peru(species_list),
  error = function(e) {
    message("Error in matching: ", e$message)
    rep("Error", length(species_list))
  }
)
print(threat_status)

# Example 2: Detailed results
detailed_results <- tryCatch(
  is_threatened_peru(species_list, return_details = TRUE),
  error = function(e) {
    message("Error in detailed matching: ", e$message)
    NULL
  }
)
if (!is.null(detailed_results)) {
  print(detailed_results)
}

# Example 3: Handling NA values gracefully
species_with_na <- c("Cattleya maxima", NA, "Polylepis incana")
status_with_na <- is_threatened_peru(species_with_na)
print(status_with_na)

# Example 4: Empty input handling
empty_result <- is_threatened_peru(character(0))
print(empty_result)  # Should return character(0)

# Example 5: Using updated database
updated_results <- tryCatch(
  is_threatened_peru(species_list, source = "updated"),
  error = function(e) {
    message("Error with updated database: ", e$message)
    rep("Error", length(species_list))
  }
)
print(updated_results)
}
}
