% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pew_download.R
\name{pew_download}
\alias{pew_download}
\title{Download datasets from the Pew Research Center}
\usage{
pew_download(area = "politics", file_id, name = getOption("pew_name"),
  org = getOption("pew_org"), phone = getOption("pew_phone"),
  email = getOption("pew_email"), reset = FALSE,
  download_dir = "pew_data", msg = TRUE, unzip = TRUE,
  delete_zip = TRUE)
}
\arguments{
\item{area}{One of the seven research areas of the Pew Research Center 
(see details).}

\item{file_id}{The unique identifier (or optionally a vector of these identifiers)
for the dataset(s) to be downloaded (see details).}

\item{name, org, phone, email}{Contact information to submit to Pew Research Center
(see details).}

\item{reset}{If TRUE, the register information will be reset. The default is FALSE.}

\item{download_dir}{The directory (relative to your working directory) to
which files from the Pew Research Center will be downloaded.}

\item{msg}{If TRUE, outputs a message showing which data set is being downloaded.}

\item{unzip}{If TRUE, the downloaded zip files will be unzipped.}

\item{delete_zip}{If TRUE, the downloaded zip files will be deleted.}
}
\value{
The function returns downloaded files.
}
\description{
\code{pew_download} provides a programmatic and reproducible means to download survey datasets from the Pew Research Center
}
\details{
The Pew Research Center has seven areas of research focus.  Pass one of the 
 following strings to the \code{area} argument to specify which area generated
 the datasets you want to download:
 
 \code{politics} U.S. Politics & Policy (the default)
 
 \code{journalism} Journalism & Media
 
 \code{internet} Internet, Science & Tech
 
 \code{religion} Religion & Public Life
 
 \code{hispanic} Hispanic Trends
 
 \code{global} Global Attitudes & Trends
 
 \code{socialtrends} Social & Demographic Trends

 To avoid requiring others to edit your scripts to insert their own contact 
 information, the default is set to fetch this information from the user's 
 .Rprofile.  Before running \code{pew_download}, then, you should be sure to
 add these options to your .Rprofile substituting your info for the example below:

 \code{
  options("pew_name" = "Juanita Herrera",
         "pew_org" = "Upper Midwest University",
         "pew_phone" = "888-000-0000",
         "pew_email" = "jherrera@uppermidwest.edu")
 }
}
\examples{
\dontrun{
 pew_download(file_id = c(20059299, 20058139))
}

}

