% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{UPDATE}
\alias{UPDATE}
\title{Generate a PostgreSQL UPDATE statement, optionally execute the statement if con is not NULL.}
\usage{
UPDATE(
  x,
  schema = NULL,
  table,
  where = list(),
  prepare = TRUE,
  types = NULL,
  returning = NULL,
  quote_text = TRUE,
  cast = TRUE,
  con = NULL
)
}
\arguments{
\item{x}{A named list, names must match the column names of the destination SQL table, values are the values to set the SQL records to.}

\item{schema}{A string, the schema name of the destination SQL table.}

\item{table}{A string, the table name of the destination SQL table.}

\item{where}{A named list, names are the columns for comparison, values are lists with a comparison operator and a value the comparison operator will check against. ex: list(col1 = list(comparison = "=", value = quoteText("b")))}

\item{prepare}{TRUE/FALSE, if TRUE, creates a PostgreSQL prepared statement for inserting the data.}

\item{types}{A vector of character strings specifying the SQL data types of the destination columns, the position of the type should match the position of the column for that type in x. Required if prepare or cast is TRUE.}

\item{returning}{A vector of character strings specifying the SQL column names to be returned by the INSERT statement.}

\item{quote_text}{TRUE/FALSE, if TRUE, calls quoteText() to add single quotes around character strings.}

\item{cast}{TRUE/FALSE, if TRUE, will add SQL to cast the data to be inserted to the specified type.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL UPDATE statement; or a string, PostgreSQL prepared statement; or the results retrieved by DBI::dbGetQuery after executing the statement.
}
\description{
Generate a PostgreSQL UPDATE statement, optionally execute the statement if con is not NULL.
}
\examples{
UPDATE(
x = list(col1 = "a", col2 = 1),
schema = "test",
table = "table1",
where = list(
  col1 = list(comparison = "=", value = quoteText("b")),
  col2 = list(comparison = "IS", value = "NULL")
),
prepare = FALSE,
types = c("TEXT", "INTEGER"),
returning = c("col3"),
quote_text = TRUE,
cast = TRUE
)
}
