/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.io;

import java.io.IOException;
import net.sf.eps2pgf.Options;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.io.TextReplacements;
import net.sf.eps2pgf.ps.GstateStack;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectFont;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.outputdevices.OutputDevice;
import org.fontbox.util.BoundingBox;

public class TextHandler {
    private GstateStack gstate;
    private TextReplacements textReplace;
    private Options.TextMode textMode;

    public TextHandler(GstateStack gstateStack) {
        this(gstateStack, null, Options.TextMode.EXACT);
    }

    public TextHandler(GstateStack gstateStack, TextReplacements textReplacements) {
        this(gstateStack, textReplacements, Options.TextMode.EXACT);
    }

    public TextHandler(GstateStack gstateStack, TextReplacements textReplacements, Options.TextMode textMode) {
        this.gstate = gstateStack;
        this.textReplace = textReplacements != null ? textReplacements : new TextReplacements();
        this.textMode = textMode;
    }

    public final void charpath(PSObjectString pSObjectString) throws PSError, ProgramError {
        PSObjectFont pSObjectFont = this.gstate.current().getFont();
        PSObjectArray pSObjectArray = pSObjectString.decode(pSObjectFont.getEncoding());
        double d = this.gstate.current().getCtm().getRotation();
        double d2 = this.gstate.current().getCtm().getMeanScaling();
        BoundingBox boundingBox = pSObjectFont.getBBox(pSObjectArray);
        double[] dArray = this.gstate.current().getCurrentPosInDeviceSpace();
        double[] dArray2 = this.getAnchor("bl", boundingBox, d2, d);
        this.gstate.current().getPath().moveto(dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        dArray2 = this.getAnchor("br", boundingBox, d2, d);
        this.gstate.current().getPath().lineto(dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        dArray2 = this.getAnchor("tr", boundingBox, d2, d);
        this.gstate.current().getPath().lineto(dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        dArray2 = this.getAnchor("tl", boundingBox, d2, d);
        this.gstate.current().getPath().lineto(dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
        this.gstate.current().getPath().closepath();
        double[] dArray3 = this.shiftPos(pSObjectFont.getWidth(pSObjectArray), 0.0, d2, d);
        dArray3 = this.gstate.current().getCtm().idtransform(dArray3);
        this.gstate.current().rmoveto(dArray3[0], dArray3[1]);
    }

    public final double[] getAnchor(String string, BoundingBox boundingBox, double d, double d2) {
        String string2 = string.length() == 0 ? "Bl" : string;
        double d3 = string2.contains("t") ? (double)boundingBox.getUpperRightY() : (string2.contains("B") ? 0.0 : (string2.contains("b") ? (double)boundingBox.getLowerLeftY() : (double)(boundingBox.getUpperRightY() + boundingBox.getLowerLeftY()) / 2.0));
        double d4 = string2.contains("l") ? (double)boundingBox.getLowerLeftX() : (string2.contains("r") ? (double)boundingBox.getUpperRightX() : (double)(boundingBox.getLowerLeftX() + boundingBox.getUpperRightX()) / 2.0);
        return this.shiftPos(d4, d3, d, d2);
    }

    public final double[] showText(OutputDevice outputDevice, PSObjectString pSObjectString) throws PSError, IOException, ProgramError {
        return this.showText(outputDevice, pSObjectString, false);
    }

    public final double[] showText(OutputDevice outputDevice, PSObjectString pSObjectString, boolean bl) throws PSError, IOException, ProgramError {
        Object object;
        PSObjectFont pSObjectFont = this.gstate.current().getFont();
        TextReplacements.Rule rule = this.textReplace.findReplacement(pSObjectString.toString());
        String string = "cc";
        String string2 = "cc";
        if (rule != null) {
            string = rule.getTexRefPoint();
            string2 = rule.getPsRefPoint();
        } else if (this.textMode == Options.TextMode.DIRECT_COPY && (rule = TextReplacements.readEmbeddedRule(pSObjectString.toString())) != null) {
            string = rule.getTexRefPoint();
            string2 = rule.getPsRefPoint();
        }
        PSObjectArray pSObjectArray = pSObjectString.decode(pSObjectFont.getEncoding());
        String string3 = rule == null && this.textMode == Options.TextMode.DIRECT_COPY ? pSObjectString.toString() : pSObjectFont.charNames2texStrings(pSObjectArray);
        double d = this.gstate.current().getCtm().getRotation();
        double d2 = this.gstate.current().getCtm().getMeanScaling();
        double d3 = pSObjectFont.getFontSize() * this.gstate.current().getMeanUserScaling();
        if (!bl) {
            object = pSObjectFont.getBBox(pSObjectArray);
            double[] dArray = this.gstate.current().getCurrentPosInDeviceSpace();
            double[] dArray2 = this.getAnchor(string2, (BoundingBox)object, d2, d);
            double[] dArray3 = new double[]{dArray[0] + dArray2[0], dArray[1] + dArray2[1]};
            if (rule == null && this.textMode == Options.TextMode.EXACT) {
                outputDevice.show(string3, dArray3, d, d3, string, this.gstate.current());
            } else if (rule == null && this.textMode == Options.TextMode.DIRECT_COPY) {
                outputDevice.show(string3, dArray3, d, Double.NaN, string, this.gstate.current());
            } else {
                outputDevice.show(rule.getTexText(), dArray3, d + rule.getRotation(), Double.NaN, string, this.gstate.current());
            }
        }
        object = this.shiftPos(pSObjectFont.getWidth(pSObjectArray), 0.0, d2, d);
        object = this.gstate.current().getCtm().idtransform((double[])object);
        return object;
    }

    final double[] shiftPos(double d, double d2, double d3, double d4) {
        double d5 = Math.toRadians(d4);
        double[] dArray = new double[]{d3 * (d * Math.cos(d5) - d2 * Math.sin(d5)), d3 * (d * Math.sin(d5) + d2 * Math.cos(d5))};
        return dArray;
    }
}

