/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectFont;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSObjectDict
extends PSObject {
    private HashMap<PSObject, PSObject> map;
    private int capacity;

    public PSObjectDict() {
        this.map = new HashMap();
        this.capacity = 0;
    }

    public PSObjectDict(int n) {
        this.map = new HashMap();
        this.capacity = n;
    }

    public PSObjectDict(PSObjectDict pSObjectDict) {
        this.map = pSObjectDict.map;
        this.capacity = pSObjectDict.capacity;
        this.copyCommonAttributes(pSObjectDict);
    }

    @Override
    public PSObjectDict clone() {
        PSObjectDict pSObjectDict = (PSObjectDict)super.clone();
        pSObjectDict.map = new HashMap();
        for (PSObject pSObject : this.map.keySet()) {
            pSObjectDict.map.put(pSObject.clone(), this.map.get(pSObject).clone());
        }
        return pSObjectDict;
    }

    @Override
    public PSObject copy(PSObject pSObject) throws PSErrorTypeCheck {
        PSObjectDict pSObjectDict = pSObject.toDict();
        for (Map.Entry<PSObject, PSObject> entry : pSObjectDict.map.entrySet()) {
            this.setKey(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public void dumpFull(String string) {
        Set<PSObject> set = this.map.keySet();
        for (PSObject pSObject : set) {
            System.out.println(string + pSObject + " -> " + this.map.get(pSObject).isis());
        }
    }

    @Override
    public PSObjectDict dup() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PSObject) {
            return this.eq((PSObject)object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public PSObject get(PSObject pSObject) throws PSErrorUndefined {
        PSObject pSObject2 = this.lookup(pSObject);
        if (pSObject2 == null) {
            throw new PSErrorUndefined("Key (" + pSObject.isis() + ") not defined in dictionary.");
        }
        return pSObject2;
    }

    public PSObject get(String string) throws PSErrorUndefined {
        return this.get(new PSObjectName(string, true));
    }

    @Override
    public List<PSObject> getItemList() {
        ArrayList<PSObject> arrayList = new ArrayList<PSObject>();
        arrayList.add(new PSObjectInt(2));
        for (Map.Entry<PSObject, PSObject> entry : this.map.entrySet()) {
            arrayList.add(entry.getKey());
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    @Override
    public String isis() {
        return "-dict(" + this.map.size() + ")-";
    }

    public boolean known(PSObject pSObject) {
        return this.map.containsKey(pSObject);
    }

    public boolean known(String string) {
        return this.map.containsKey(new PSObjectName(string, true));
    }

    @Override
    public int length() {
        return this.map.size();
    }

    public PSObject lookup(PSObject pSObject) {
        return this.map.get(pSObject);
    }

    public PSObject lookup(String string) {
        return this.map.get(new PSObjectName(string, true));
    }

    public int maxlength() {
        return Math.max(this.capacity, this.length());
    }

    @Override
    public void put(PSObject pSObject, PSObject pSObject2) throws PSErrorTypeCheck {
        this.setKey(pSObject, pSObject2);
    }

    public void setKey(PSObject pSObject, PSObject pSObject2) {
        PSObject pSObject3 = pSObject;
        if (pSObject3 instanceof PSObjectString) {
            pSObject3 = new PSObjectName(((PSObjectString)pSObject3).toString(), true);
        }
        this.map.put(pSObject3, pSObject2);
    }

    public void setKey(String string, PSObject pSObject) {
        this.map.put(new PSObjectName(string, true), pSObject);
    }

    public void setKey(String string, String string2) {
        this.map.put(new PSObjectName(string, true), new PSObjectString(string2));
    }

    public PSObjectString setKey(PSObject pSObject, String string) {
        PSObjectString pSObjectString = new PSObjectString(string);
        this.map.put(pSObject, pSObjectString);
        return pSObjectString;
    }

    @Override
    public PSObjectDict toDict() {
        return this;
    }

    @Override
    public PSObjectFont toFont() {
        return new PSObjectFont(this);
    }

    public String toString() {
        return "Dict: (" + this.map.size() + " items)";
    }

    @Override
    public String type() {
        return "dicttype";
    }

    public void undef(PSObject pSObject) throws PSErrorTypeCheck {
        this.map.remove(pSObject);
    }
}

