.Random.seed <-
c(403L, 161L, 275174846L, -599365090L, -1571107922L, 235608048L, 
381393983L, 412074733L, 1943663034L, -984442620L, -2038149693L, 
-1839424465L, 2132305334L, 1278167821L, 321239116L, -1357123044L, 
1861762526L, 285409158L, 337364579L, 1552751412L, 1911514707L, 
1650080485L, -8035491L, 1286059613L, 2013508503L, 1828588177L, 
1715277902L, -537554953L, -783030264L, -1954121695L, 537957284L, 
1314666569L, -260032211L, 1492960770L, 1410631587L, -587705437L, 
-2054412616L, 1958122838L, -1245792831L, -1476055086L, -1023070109L, 
1872865355L, -953615947L, -815816823L, 1002405972L, -320157890L, 
30279056L, 1866664583L, 211798751L, -1720623571L, 1169336275L, 
1164815073L, 938595552L, -2052498009L, 1414165958L, -169091955L, 
-1548095995L, 1650674178L, 836919978L, -645890952L, 508531842L, 
1735319899L, -1965665649L, 1508228487L, -207255515L, 448848132L, 
-722399451L, 1565060156L, 1448319533L, -726186390L, -1049252319L, 
1709491811L, -808633565L, 791179759L, -1918083291L, -1793547812L, 
1632619741L, -1535834452L, -1000804334L, 1418750498L, -1149762484L, 
-159891817L, -1358727019L, 993697673L, 265079538L, -2015569050L, 
1090467386L, 843261404L, -1447764970L, 304175751L, 1895958065L, 
-1079055112L, 1608877414L, 150759953L, 1318700654L, 405561007L, 
-699665695L, -648936602L, -560303594L, -1014788411L, 356872314L, 
1415167070L, 1457003257L, 1025615575L, 1219429188L, 1072374375L, 
1988864358L, -766157183L, 151812897L, -1414934119L, 786337355L, 
539948124L, -1817313811L, 418183483L, -1962783019L, 951206565L, 
-1421795137L, -46043516L, -451708491L, -1202599170L, -805818366L, 
-1035716791L, -120088530L, -1358508910L, -421766229L, 392938419L, 
1553748052L, -2012059164L, -1661380143L, -1460401669L, -1611622192L, 
1278784106L, -655298862L, -627932851L, -1895160840L, 1383876037L, 
-989179742L, 1565605700L, 1741381510L, 392839784L, -306611940L, 
-1921589235L, 1791191484L, 1814555712L, 1510062171L, -499016051L, 
1274530891L, -376564222L, -210758525L, -306446879L, -37844048L, 
1869293188L, -379021417L, 905479182L, 320386053L, 28230156L, 
-867382545L, 1898304907L, -741412519L, -2092704028L, 1673695775L, 
1791115554L, 351313799L, 52261582L, -1079623952L, -1631942353L, 
-1141081926L, 1590437654L, 1294362232L, -2123108282L, -808009732L, 
617637701L, -1880865905L, -176411069L, 1119796368L, 1144677483L, 
1586897895L, -10686552L, -762706257L, 497094284L, -1043024999L, 
589559605L, 829895159L, -1718539646L, 588926530L, -653688720L, 
2110512590L, 797305658L, 1074824181L, 498283405L, -2064232774L, 
317362840L, -122968605L, 1954264863L, 1246804242L, 1071937124L, 
-1723004034L, -817104556L, 1273800637L, -152548279L, 137333653L, 
1535280490L, -646876179L, -1406445376L, 768016329L, 2108099586L, 
-1744093262L, 259314427L, 1769817516L, -353535696L, -1584735684L, 
-553032772L, 1592968220L, 934469259L, -543090923L, 464820375L, 
-628937661L, -588617686L, -431042278L, 390992496L, -1443199854L, 
567582255L, 730122513L, 2137556121L, 1869307850L, 1462741843L, 
160482036L, -2081434898L, -734062123L, 1780515787L, 121364717L, 
-320550582L, 620851541L, -888236754L, 729578760L, -82467202L, 
-561525322L, -2125625497L, -2031944921L, 604749886L, 1580371118L, 
970869578L, -6657666L, -1114343074L, 2110120435L, 560850761L, 
1271897013L, 1526674141L, -841379688L, -372875542L, 2057697551L, 
-115969662L, 520810751L, -405877603L, -1037366764L, 1290900396L, 
1072433526L, -821298485L, 1064552087L, -282101710L, 1761072593L, 
1802738695L, 1739295217L, 891207227L, 1314597242L, -1059960479L, 
158221969L, -1575005257L, 223341558L, -911867857L, 293833175L, 
1137851391L, 2059670681L, -1883612377L, -192863953L, -1297903145L, 
1038354854L, 1234722248L, -1863783968L, -498254927L, 831921837L, 
853241698L, -1591728976L, 983008177L, -944721088L, -2033826275L, 
-52928031L, -685507472L, 1859663818L, -720575002L, 604945485L, 
-1119551589L, 1733531624L, 904207529L, -1013665003L, 1700910035L, 
-808113437L, 107064973L, -420464965L, 1140773903L, -1709338180L, 
-652353187L, -646707302L, -1057204451L, 1809656224L, -1372600460L, 
-1118227920L, -406901873L, -1428586175L, 1585935076L, 879962260L, 
-1564587582L, -321741356L, 1489758619L, -2136841934L, -1377047679L, 
1308924244L, 2081427855L, -241015414L, -2123713393L, 1361584377L, 
288500042L, 600837094L, -1222730315L, 881621317L, -1647189048L, 
202560470L, 738787445L, -704639810L, -586889250L, 1288266534L, 
-2128460579L, 1895303358L, 2096848105L, 1276754821L, -1777349305L, 
1317576705L, -819612073L, 345427897L, -363070266L, 1654095774L, 
522703768L, 766704478L, 410180656L, -1724764018L, 338051883L, 
-411262255L, -1183939449L, -401796045L, -15769848L, 1631466443L, 
-1518552815L, 1145572197L, 214943466L, 888380621L, 1453288989L, 
785918573L, 377692326L, -1464620814L, -1074827465L, 1098774709L, 
637522148L, 2018191989L, 1110121118L, 923137890L, 784451882L, 
182239198L, -806903108L, -1910224037L, -970674483L, -128480075L, 
-631575459L, 1939346458L, 60329467L, -480038002L, 1999318256L, 
1675710201L, 2101213667L, -2081167644L, -1069346638L, -791394953L, 
-369315704L, -1446496754L, 1260494026L, 848935097L, 715635036L, 
-1553171119L, -258267875L, 1748347219L, -356729360L, -639520202L, 
-475900870L, -934623228L, -1109487749L, -248932380L, -1803012049L, 
-316671890L, 184869553L, 919363271L, -2039953007L, 1796340836L, 
1942364726L, -891667738L, 2143527525L, -393985632L, -1352385321L, 
-551510272L, 2122251354L, -1505696260L, -1596558992L, -368427281L, 
-1325894080L, 2089298991L, 1961911908L, -217558786L, 895604665L, 
1525467966L, 156343203L, -2125408021L, 1704106191L, -1175582724L, 
-608143794L, 1432631962L, -399672841L, -2125439152L, -1399127807L, 
1902495672L, -414756903L, -1167370588L, 250813882L, 324566469L, 
1885142205L, 643263122L, -654709219L, -1855141075L, -1029603060L, 
604966372L, -1655111734L, -1130026500L, -1058145312L, 1660573879L, 
-1049537434L, 896162900L, -1386454185L, -608813934L, -507929346L, 
1394087372L, -677158349L, -371929594L, 1422973276L, -141993074L, 
-1123040496L, -1158784767L, -1781350886L, -499709045L, 719916788L, 
2122796546L, -1932101630L, -877674785L, -294493670L, 1608724643L, 
-1543088472L, -313159078L, 949322432L, 1424701538L, -40287049L, 
-505709321L, 356656993L, -2036688360L, 1561531484L, -1829003466L, 
-2084722147L, 613011501L, 92014551L, -532104314L, -777011448L, 
-1916620227L, 2128540647L, 956146501L, 423356183L, 1786674186L, 
-1161571239L, -460511302L, 287594931L, -2106325421L, -466971510L, 
-19020313L, 529731404L, -2032789772L, 1009002628L, -1180325530L, 
1620908452L, 1688087059L, -1254354324L, -1998635530L, -42373591L, 
2106840727L, 312521708L, 3237761L, 1197308252L, 1395139194L, 
1162102354L, 1716161988L, -245225645L, 1485715329L, 1407702910L, 
-653183822L, 1953604857L, 36171970L, -365592552L, 1544688515L, 
-623393382L, -971439431L, 1625041762L, -217220796L, 69746590L, 
1895735687L, -1563596094L, -1059722469L, 715342598L, 169584267L, 
1183907287L, 1532329644L, -251157797L, -25974445L, 1190886991L, 
1239356268L, 230180960L, 914745832L, -778557091L, -1073274571L, 
1323533793L, 548554127L, 1161136009L, 1860414747L, -1847268672L, 
-1756710669L, -881283733L, 1440232265L, -375634621L, 1703832879L, 
-1634049972L, -772921509L, -1111539262L, -2003638508L, 98038793L, 
-1472375250L, 436114306L, -1333283151L, -1015112243L, -2020344762L, 
62094231L, -311297741L, 1718174271L, -1807871877L, -531348173L, 
2072532835L, -737738752L, 821277001L, -106388848L, -1778987333L, 
-696346651L, -248669818L, -1461779928L, -431884325L, 565553609L, 
879374422L, -331674022L, -1129506224L, 1910791896L, 1701393520L, 
-772822969L, 2117181319L, 1661891077L, 1542751781L, -2102640363L, 
-954997307L, -635418739L, -1866503675L, -1785997752L, -1649948623L, 
1748653631L, 1079049864L, -1160041203L, 975532842L, -1420861176L, 
-2039752890L, 741859345L, 1616151165L, 665412315L, 1597175420L, 
-1005339997L, -1113383016L, -1144968392L, 1932343300L, -688193655L, 
1427974825L, 1641071891L, 568857890L, -534221141L, 1243397870L, 
717393516L, -315931148L, 2136679219L, 650049758L, -2084182960L, 
2069644080L, -753294689L, -1374658159L, -55850088L, -890174054L, 
1336297240L, -1866780573L, 1108205642L, -1785973163L, -1605998553L, 
-1977275284L, -1200656906L, 1192537444L, 25026900L, -1281814156L, 
-1401255180L, -82370188L, 1605555791L, -74880810L, 1056912408L
)
a <-
18614L
b <-
245404L
cluster_mat <-
function (mat, distance, method) 
{
    if (!(method %in% c("ward", "single", "complete", "average", 
        "mcquitty", "median", "centroid"))) {
        stop("clustering method has to one form the list: 'ward', 'single', 'complete', 'average', 'mcquitty', 'median' or 'centroid'.")
    }
    if (!(distance %in% c("correlation", "euclidean", "maximum", 
        "manhattan", "canberra", "binary", "minkowski"))) {
        stop("distance measure has to one form the list: 'correlation', 'euclidean', 'maximum', 'manhattan', 'canberra', 'binary', 'minkowski'")
    }
    if (distance == "correlation") {
        d = dist(1 - cor(t(mat)))
    }
    else {
        d = dist(mat, method = distance)
    }
    return(hclust(d, method = method))
}
convert_annotations <-
function (annotation, annotation_colors) 
{
    new = annotation
    for (i in 1:ncol(annotation)) {
        a = annotation[, i]
        b = annotation_colors[[colnames(annotation)[i]]]
        if (class(a) %in% c("character", "factor")) {
            a = as.character(a)
            if (length(setdiff(names(b), a)) > 0) {
                stop(sprintf("Factor levels on variable %s do not match with annotation_colors", 
                  colnames(annotation)[i]))
            }
            new[, i] = b[a]
        }
        else {
            a = cut(a, breaks = 100)
            new[, i] = colorRampPalette(b)(100)[a]
        }
    }
    return(as.matrix(new))
}
draw_annotation_legend <-
function (annotation, annotation_colors, border_color, ...) 
{
    y = unit(1, "npc")
    text_height = unit(1, "grobheight", textGrob("FGH", gp = gpar(...)))
    for (i in names(annotation_colors)) {
        grid.text(i, x = 0, y = y, vjust = 1, hjust = 0, gp = gpar(fontface = "bold", 
            ...))
        y = y - 1.5 * text_height
        if (class(annotation[, i]) %in% c("character", "factor")) {
            for (j in 1:length(annotation_colors[[i]])) {
                grid.rect(x = unit(0, "npc"), y = y, hjust = 0, 
                  vjust = 1, height = text_height, width = text_height, 
                  gp = gpar(col = border_color, fill = annotation_colors[[i]][j]))
                grid.text(names(annotation_colors[[i]])[j], x = text_height * 
                  1.3, y = y, hjust = 0, vjust = 1, gp = gpar(...))
                y = y - 1.5 * text_height
            }
        }
        else {
            yy = y - 4 * text_height + seq(0, 1, 0.02) * 4 * 
                text_height
            h = 4 * text_height * 0.02
            grid.rect(x = unit(0, "npc"), y = yy, hjust = 0, 
                vjust = 1, height = h, width = text_height, gp = gpar(col = "#FFFFFF00", 
                  fill = colorRampPalette(annotation_colors[[i]])(50)))
            txt = rev(range(grid.pretty(range(annotation[, i]))))
            yy = y - c(0, 3) * text_height
            grid.text(txt, x = text_height * 1.3, y = yy, hjust = 0, 
                vjust = 1, gp = gpar(...))
            y = y - 4.5 * text_height
        }
        y = y - 1.5 * text_height
    }
}
draw_annotations <-
function (converted_annotations, border_color) 
{
    n = ncol(converted_annotations)
    m = nrow(converted_annotations)
    x = (1:m)/m - 1/2/m
    y = cumsum(rep(8, n)) - 4 + cumsum(rep(2, n))
    for (i in 1:m) {
        grid.rect(x = x[i], unit(y[1:n], "bigpts"), width = 1/m, 
            height = unit(8, "bigpts"), gp = gpar(fill = converted_annotations[i, 
                ], col = border_color))
    }
}
draw_colnames <-
function (coln, ...) 
{
    m = length(coln)
    x = (1:m)/m - 1/2/m
    grid.text(coln, x = x, y = unit(0.96, "npc"), vjust = 0.5, 
        hjust = 0, rot = 270, gp = gpar(...))
}
draw_dendrogram <-
function (hc, horizontal = T) 
{
    h = hc$height/max(hc$height)/1.05
    m = hc$merge
    o = hc$order
    n = length(o)
    m[m > 0] = n + m[m > 0]
    m[m < 0] = abs(m[m < 0])
    dist = matrix(0, nrow = 2 * n - 1, ncol = 2, dimnames = list(NULL, 
        c("x", "y")))
    dist[1:n, 1] = 1/n/2 + (1/n) * (match(1:n, o) - 1)
    for (i in 1:nrow(m)) {
        dist[n + i, 1] = (dist[m[i, 1], 1] + dist[m[i, 2], 1])/2
        dist[n + i, 2] = h[i]
    }
    draw_connection = function(x1, x2, y1, y2, y) {
        grid.lines(x = c(x1, x1), y = c(y1, y))
        grid.lines(x = c(x2, x2), y = c(y2, y))
        grid.lines(x = c(x1, x2), y = c(y, y))
    }
    if (horizontal) {
        for (i in 1:nrow(m)) {
            draw_connection(dist[m[i, 1], 1], dist[m[i, 2], 1], 
                dist[m[i, 1], 2], dist[m[i, 2], 2], h[i])
        }
    }
    else {
        gr = rectGrob()
        pushViewport(viewport(height = unit(1, "grobwidth", gr), 
            width = unit(1, "grobheight", gr), angle = 90))
        for (i in 1:nrow(m)) {
            draw_connection(dist[m[i, 1], 1], dist[m[i, 2], 1], 
                dist[m[i, 1], 2], dist[m[i, 2], 2], h[i])
        }
        upViewport()
    }
}
draw_legend <-
function (color, breaks, legend, ...) 
{
    height = min(unit(1, "npc"), unit(150, "bigpts"))
    pushViewport(viewport(x = 0, y = unit(1, "npc"), just = c(0, 
        1), height = height))
    legend_pos = (legend - min(breaks))/(max(breaks) - min(breaks))
    breaks = (breaks - min(breaks))/(max(breaks) - min(breaks))
    h = breaks[-1] - breaks[-length(breaks)]
    grid.rect(x = 0, y = breaks[-length(breaks)], width = unit(10, 
        "bigpts"), height = h, hjust = 0, vjust = 0, gp = gpar(fill = color, 
        col = "#FFFFFF00"))
    grid.text(legend, x = unit(12, "bigpts"), y = legend_pos, 
        hjust = 0, gp = gpar(...))
    upViewport()
}
draw_matrix <-
function (matrix, border_color) 
{
    n = nrow(matrix)
    m = ncol(matrix)
    x = (1:m)/m - 1/2/m
    y = (1:n)/n - 1/2/n
    for (i in 1:m) {
        grid.rect(x = x[i], y = y[1:n], width = 1/m, height = 1/n, 
            gp = gpar(fill = matrix[, i], col = border_color))
    }
}
draw_rownames <-
function (rown, ...) 
{
    n = length(rown)
    y = (1:n)/n - 1/2/n
    grid.text(rown, x = unit(0.04, "npc"), y = y, vjust = 0.5, 
        hjust = 0, gp = gpar(...))
}
generate_annotation_colours <-
function (annotation, annotation_colors) 
{
    if (is.na(annotation_colors)[[1]][1]) {
        annotation_colors = list()
    }
    count = 0
    for (i in 1:ncol(annotation)) {
        if (class(annotation[, i]) %in% c("character", "factor")) {
            count = count + length(unique(annotation[, i]))
        }
    }
    factor_colors = hcl(h = seq(0, 360, length.out = count + 
        1)[-1], 75, 75)
    set.seed(5345)
    for (i in 1:ncol(annotation)) {
        if (!(colnames(annotation)[i] %in% names(annotation_colors))) {
            if (class(annotation[, i]) %in% c("character", "factor")) {
                ind = sample(1:length(factor_colors), length(unique(annotation[, 
                  i])))
                annotation_colors[[colnames(annotation)[i]]] = factor_colors[ind]
                names(annotation_colors[[colnames(annotation)[i]]]) = levels(as.factor(annotation[, 
                  i]))
                factor_colors = factor_colors[-ind]
            }
            else {
                h = round(runif(1) * 360)
                annotation_colors[[colnames(annotation)[i]]] = rev(sequential_hcl(2, 
                  h, l = c(50, 95)))
            }
        }
    }
    return(annotation_colors)
}
generate_breaks <-
function (x, n) 
{
    seq(min(x, na.rm = T), max(x, na.rm = T), length.out = n + 
        1)
}
heatmap_motor <-
function (matrix, border_color, cellwidth, cellheight, tree_col, 
    tree_row, treeheight_col, treeheight_row, filename, width, 
    height, breaks, color, legend, annotation, annotation_colors, 
    annotation_legend, ...) 
{
    grid.newpage()
    lo(coln = colnames(matrix), rown = rownames(matrix), cellwidth = cellwidth, 
        cellheight = cellheight, treeheight_col = treeheight_col, 
        treeheight_row = treeheight_row, legend = legend, annotation = annotation, 
        annotation_colors = annotation_colors, annotation_legend = annotation_legend, 
        ...)
    if (!is.na(tree_col[[1]][1])) {
        pushViewport(vplayout(1, 2))
        draw_dendrogram(tree_col, horizontal = T)
        upViewport()
    }
    if (!is.na(tree_row[[1]][1])) {
        pushViewport(vplayout(3, 1))
        draw_dendrogram(tree_row, horizontal = F)
        upViewport()
    }
    pushViewport(vplayout(3, 2))
    draw_matrix(matrix, border_color)
    upViewport()
    if (length(colnames(matrix)) != 0) {
        pushViewport(vplayout(4, 2))
        draw_colnames(colnames(matrix), ...)
        upViewport()
    }
    if (length(rownames(matrix)) != 0) {
        pushViewport(vplayout(3, 3))
        draw_rownames(rownames(matrix), ...)
        upViewport()
    }
    if (!is.na(annotation[[1]][1])) {
        pushViewport(vplayout(2, 2))
        converted_annotation = convert_annotations(annotation, 
            annotation_colors)
        draw_annotations(converted_annotation, border_color)
        upViewport()
    }
    if (!is.na(annotation[[1]][1]) & annotation_legend) {
        pushViewport(vplayout(3, 5))
        draw_annotation_legend(annotation, annotation_colors, 
            border_color, ...)
        upViewport()
    }
    if (!is.na(legend[1])) {
        pushViewport(vplayout(3, 4))
        draw_legend(color, breaks, legend, ...)
        upViewport()
    }
    pushViewport(vplayout(1:4, 1:5))
    if (!is.na(filename)) {
        if (is.na(height)) {
            height = convertHeight(unit(0:1, "npc"), "inches", 
                valueOnly = T)[2]
        }
        if (is.na(width)) {
            width = convertWidth(unit(0:1, "npc"), "inches", 
                valueOnly = T)[2]
        }
        pdf(filename, height = height, width = width)
        heatmap_motor(matrix, cellwidth = cellwidth, cellheight = cellwidth, 
            border_color = border_color, tree_col = tree_col, 
            tree_row = tree_row, treeheight_col = treeheight_col, 
            treeheight_row = treeheight_row, breaks = breaks, 
            color = color, legend = legend, annotation = annotation, 
            annotation_colors = annotation_colors, annotation_legend = annotation_legend, 
            file = NA, ...)
        dev.off()
    }
}
lo <-
function (rown, coln, cellheight = NA, cellwidth = NA, treeheight_col, 
    treeheight_row, legend, annotation, annotation_colors, annotation_legend, 
    ...) 
{
    if (!is.null(coln[1])) {
        longest_coln = which.max(nchar(coln))
        coln_height = unit(1.1, "grobheight", textGrob(coln[longest_coln], 
            rot = 90, gp = gpar(...)))
    }
    else {
        coln_height = unit(5, "bigpts")
    }
    if (!is.null(rown[1])) {
        longest_rown = which.max(nchar(rown))
        rown_width = unit(1.2, "grobwidth", textGrob(rown[longest_rown], 
            gp = gpar(...)))
    }
    else {
        rown_width = unit(5, "bigpts")
    }
    if (!is.na(legend[1])) {
        longest_break = which.max(nchar(as.character(legend)))
        longest_break = unit(1.1, "grobwidth", textGrob(as.character(legend)[longest_break], 
            gp = gpar(...)))
        title_length = unit(1.1, "grobwidth", textGrob("Scale", 
            gp = gpar(fontface = "bold", ...)))
        legend_width = unit(12, "bigpts") + longest_break * 1.2
        legend_width = max(title_length, legend_width)
    }
    else {
        legend_width = unit(0, "bigpts")
    }
    if (!is.na(annotation[[1]][1])) {
        annot_height = unit(ncol(annotation) * (8 + 2) + 2, "bigpts")
        longest_ann = which.max(nchar(as.matrix(annotation)))
        annot_legend_width = unit(1.2, "grobwidth", textGrob(as.matrix(annotation)[longest_ann], 
            gp = gpar(...))) + unit(12, "bigpts")
        if (!annotation_legend) {
            annot_legend_width = unit(0, "npc")
        }
    }
    else {
        annot_height = unit(0, "bigpts")
        annot_legend_width = unit(0, "bigpts")
    }
    treeheight_col = unit(treeheight_col, "bigpts") + unit(5, 
        "bigpts")
    treeheight_row = unit(treeheight_row, "bigpts") + unit(5, 
        "bigpts")
    if (is.na(cellwidth)) {
        matwidth = unit(1, "npc") - rown_width - legend_width - 
            treeheight_row - annot_legend_width
    }
    else {
        matwidth = unit(cellwidth * length(coln), "bigpts")
    }
    if (is.na(cellheight)) {
        matheight = unit(1, "npc") - coln_height - treeheight_col - 
            annot_height
    }
    else {
        matheight = unit(cellheight * length(rown), "bigpts")
    }
    pushViewport(viewport(layout = grid.layout(nrow = 4, ncol = 5, 
        widths = unit.c(treeheight_row, matwidth, rown_width, 
            legend_width, annot_legend_width), heights = unit.c(treeheight_col, 
            annot_height, matheight, coln_height))))
}
pheatmap <-
function (mat, color = colorRampPalette(rev(c("#D73027", "#FC8D59", 
    "#FEE090", "#FFFFBF", "#E0F3F8", "#91BFDB", "#4575B4")))(100), 
    breaks = NA, border_color = "grey60", cellwidth = NA, cellheight = NA, 
    scale = "none", cluster_rows = TRUE, cluster_cols = TRUE, 
    clustering_distance = "euclidean", clustering_method = "complete", 
    treeheight_row = ifelse(cluster_rows, 50, 0), treeheight_col = ifelse(cluster_cols, 
        50, 0), legend = TRUE, annotation = NA, annotation_colors = NA, 
    annotation_legend = TRUE, show_rownames = T, show_colnames = T, 
    filename = NA, width = NA, height = NA, ...) 
{
    mat = as.matrix(mat)
    mat = scale_mat(mat, scale)
    if (cluster_rows) {
        tree_row = cluster_mat(mat, distance = clustering_distance, 
            method = clustering_method)
        mat = mat[tree_row$order, ]
    }
    else {
        tree_row = NA
        treeheight_row = 0
    }
    if (cluster_cols) {
        tree_col = cluster_mat(t(mat), distance = clustering_distance, 
            method = clustering_method)
        mat = mat[, tree_col$order]
    }
    else {
        tree_col = NA
        treeheight_col = 0
    }
    if (is.na(breaks[1])) {
        breaks = generate_breaks(as.vector(mat), length(color))
    }
    if (legend) {
        legend = grid.pretty(range(as.vector(breaks)))
    }
    else {
        legend = NA
    }
    mat = scale_colours(mat, col = color, breaks = breaks)
    if (!is.na(annotation[[1]][1])) {
        annotation = annotation[colnames(mat), , drop = F]
        annotation_colors = generate_annotation_colours(annotation, 
            annotation_colors)
    }
    if (!show_rownames) {
        rownames(mat) = NULL
    }
    if (!show_colnames) {
        colnames(mat) = NULL
    }
    heatmap_motor(mat, border_color = border_color, cellwidth = cellwidth, 
        cellheight = cellheight, treeheight_col = treeheight_col, 
        treeheight_row = treeheight_row, tree_col = tree_col, 
        tree_row = tree_row, filename = filename, width = width, 
        height = height, breaks = breaks, color = color, legend = legend, 
        annotation = annotation, annotation_colors = annotation_colors, 
        annotation_legend = annotation_legend, ...)
}
scale_colours <-
function (mat, col = rainbow(10), breaks = NA) 
{
    mat = as.matrix(mat)
    return(matrix(scale_vec_colours(as.vector(mat), col = col, 
        breaks = breaks), nrow(mat), ncol(mat), dimnames = list(rownames(mat), 
        colnames(mat))))
}
scale_mat <-
function (mat, scale) 
{
    if (!(scale %in% c("none", "row", "column"))) {
        stop("scale argument shoud take values: 'none', 'row' or 'column'")
    }
    mat = switch(scale, none = mat, row = scale_rows(mat), column = t(scale_rows(t(mat))))
    return(mat)
}
scale_rows <-
function (x) 
{
    m = apply(x, 1, mean)
    s = apply(x, 1, sd)
    return((x - m)/s)
}
scale_vec_colours <-
function (x, col = rainbow(10), breaks = NA) 
{
    return(col[as.numeric(cut(x, breaks = breaks, include.lowest = T))])
}
vplayout <-
function (x, y) 
{
    return(viewport(layout.pos.row = x, layout.pos.col = y))
}

