% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_eval.R
\name{ph_eval}
\alias{ph_eval}
\title{Evaluate a phenotype classification model.}
\usage{
ph_eval(pred, obs)
}
\arguments{
\item{pred}{A \code{factor} value of predicted classes.}

\item{obs}{A \code{factor} value of the observed or actual classes.}
}
\value{
A \code{data.frame} of confusion matrix evaluation results; for the multi-class case, the results are averaged across all class levels.
}
\description{
The \code{ph_eval} function generates a confusion matrix for binary or multi-class classification; for the multi-class case, the results are averaged across all class levels.
}
\examples{
## Import data.
data(ph_crocs)
\donttest{
## Remove anomalies with autoencoder.
rm_outs <- ph_anomaly(df = ph_crocs, ids_col = "Biosample",
                      class_col = "Species", method = "ae")
## Preprocess anomaly-free data frame into train, validation, and test sets
## with PCs as predictors.
pc_dfs <- ph_prep(df = rm_outs$df, ids_col = "Biosample",
                  class_col = "Species", vali_pct = 0.15,
                  test_pct = 0.15, method = "pca")
## Echo control object for train function.
ctrl <- ph_ctrl(ph_crocs$Species, resample_method = "boot")
## Train a few models for ensemble, although more is preferable.
## Note: Increasing n_cores will dramatically reduce train time.
train_models <- ph_train(train_df = pc_dfs$train_df,
                         vali_df = pc_dfs$vali_df,
                         test_df = pc_dfs$test_df,
                         class_col = "Species",
                         ctrl = ctrl,
                         task = "multi",
                         methods = c("lda", "mda",
                         "nnet", "pda", "sparseLDA"),
                         tune_length = 5,
                         quiet = FALSE)
## Evaluate e.g. the first model.
test_pred <- predict(train_models$train_models[[1]], pc_dfs$test_df)
test_obs <- as.factor(pc_dfs$test_df$Species)
test_cm <- ph_eval(pred = test_pred, obs = test_obs)
}
}
