#' phenology is the help function for phenology package.
#' @title Help for phenology package.
#' @author Marc Girondot \email{marc.girondot@@u-psud.fr}
#' @return None
#' @description Help function for phenology package.
#' @export


phenology <-
function() {

  if (!exists(as.character(substitute(phenology)))) phenology <- new.env()
  wd<-getwd()
	cat("Help is available for each function with function_name(help=TRUE)\n")
	cat("\n")

	repeat {

	cat("\n")
	cat("The different functions to be used are:\n")
	cat("1:  Change the working directory:\n")
	cat("    setwd('", wd, "')\n", sep="")
	cat("2:  Read data from file:\n")
	cat("    newdata<-read.delim('Essai.txt', header=FALSE) \n")
	cat("3:  Format data to be analyzed:\n")
	cat("    Formated<-add_phenology(origin=previousdata, add=DATA, name='Site', \n")
	cat("    + reference=as.Date('2001-01-01'), format='%d/%m/%y')\n")
    cat("4:  Introduce fixed parameters:\n")
	cat("    pfixed<-c(Flat=0, Min=0)\n")	
	cat("5:  Estimate set of initial values:\n")
	cat("    par<-par_init(data=Formated, parametersfixed=parfixed)\n")
	cat("6:  Fit the phenology:\n")
	cat("    + result<-  fit_phenology(data = NULL, parametersfit = NULL, parametersfixed = NA,\n")
	cat("    + trace = 1, maxit = 500, method_incertitude = 2, zero_counts = TRUE,\n")
	cat("    hessian = TRUE)\n")	
	cat("7:  Estimate likelihood:\n")
	cat("    Likelihood_phenology(data=dta, parametersfit=x, parametersfixed=parfixed,\n")
	cat("    + method_incertitude=2)\n")
	cat("8:  Transform a set of parameters from Begin and End to LengthB and LengthE:\n")
	cat("    para<-BE_to_LBLE(parameters=para)\n")
	cat("9:  Transform a set of parameters from LengthB and LengthE to Begin and End:\n")
	cat("    para<-LBLE_to_BE(parameters=para)\n")
	cat("11: Plot the nth timeseries (data is optional if result is indicated):\n")
	cat("    plot_phenology(result=res, data=dta, pdf=TRUE, series=n)\n")
	cat("12: Take the fitted parameters from a fitted result:\n")
	cat("    para<-extract_result(result=res)\n")
	cat("13: Remove the site information from the name of parameters:\n")
	cat("    para<-remove_site(parameters=para)\n")
	cat("14: Add standard deviation for a fixed parameter.\n")
	cat("    parfixed<-add_SD(parametersfixed=NULL, parameter=name, SD=value)\n")
	cat("15: Generate a likelihood map varying Phi and Delta.\n")
	cat("    Lmap<-map_phenology(data=dta, parametersfit=x, parametersfixed=parfixed,\n")
	cat("    + Phi=seq(from=0.2,to=20, length.out=100), method_incertitude=2, zero_counts=TRUE)\n")
	cat("16: Plot the map generated by map_phenology()\n")
	cat("    plot_map(map=Lmap, pdf=FALSE, pdfname='Map.pdf')\n")	
	cat("17: Plot the -Ln L according to Phi value for a map\n")
	cat("    plot_phi(map=Lmap, pdf=FALSE, pdfname='Map.pdf')\n")
	cat("18: Plot the -Ln L according to Delta value for a map\n")
	cat("    plot_delta(map=Lmap, pdf=FALSE, pdfname='Map.pdf')\n")
	cat("19: This function is used to shift sinusoid parameters from '', '1' or '2'.\n")
	cat("    par<-shift_sinusoid(parameters=parx, from='', to='1')\n")
	cat("\nEnter the number of the function to be used (1, 2, 3, 4, 5, 8, 9, 12, 13, 14): ")
	
	
	
	f<-scan(nmax=1, quiet=TRUE)
	
	if(length(f)!=0) {
#####################################################################
		if(f==1) {
			cat("1: setwd()\n")
			cat("Working directory, press enter to choose the directory from a file inside the directory:\n")
			p<-scan(nmax=1, what="character", allowEscapes=TRUE, sep="*", quiet=TRUE)
			if(length(p)!=0) {
				setwd(p)
				wd<-getwd()
				print("Done !")
			} else {
				nm <- try(file.choose(), silent=TRUE)
				if(class(nm)!="try-error") {
					setwd(dirname(nm))
					wd<-getwd()
				}
			}
		}
#####################################################################
		if(f==2) {
			cat("2: newdata<-read.delim('Essai.txt', , header=FALSE) \n")
			cat("Choose the file to be read:\n")
			nm <- try(file.choose(), silent=TRUE)
			if(class(nm)!="try-error") {
				cat("Name of object in which the file will be read: DATA [defaut]\n")
				dta<-scan(nmax=1, what="character", quiet=TRUE)
				if(length(dta)!=0) {dta <- "DATA"}
				cat("Have the data a header (Y/N [default]):\n")
				hed<-scan(nmax=1, what="character", quiet=TRUE)
				if(length(hed)==0) {hed<-"N"}
				hedF<-ifelse(hed=="Y", TRUE, FALSE)
				assign(dta, read.delim(nm, header=hedF), envir = phenology)
				print("Done !")				
			}
		}
#####################################################################
		if(f==3) {
			cat("3:  Format data to be analyzed:\n")
			cat("    data<-add_phenology(previous=previousdata, add=newdata, name='Site', \n")
			cat("    + reference=as.Date('2001-01-01'), format='%d/%m/%y')\n")
			cat("Name of previous formated data in which the new ones will be added: Enter for none\n")
			origin <- scan(nmax=1, what="character", quiet=TRUE)
			if (origin=="") {origin <- NULL}
			cat("Name of new formated data: Formated [default]\n")
			formated <- scan(nmax=1, what="character", quiet=TRUE)
			if (formated=="") {formated <- "DATA"}
			cat("Name of new data to add: DATA [default]\n")
			dta <- scan(nmax=1, what="character", quiet=TRUE)
			if (dta=="") {dta <- "DATA"}
			cat("Name of new site: Site [default]\n")
			name <- scan(nmax=1, what="character", quiet=TRUE)
			if (name=="") {name <- "Site"}
			cat("Reference date (day 0): format YYYY-MM-DD\n")
			dateref <- scan(nmax=1, what="character", quiet=TRUE)
			dateref <- as.Date(dateref)
			cat("Format for dates on file: %d/%m/%y [Default]\n")
			dateformat <- scan(nmax=1, what="character", quiet=TRUE)
			if (dateformat=="") {dateformat <- "%d/%m/%y"}
			
			
			assign(formated, add_phenology(previous=get(origin, envir = phenology), add=get(dta, envir = phenology), name=name, reference=dateref, format=dateformat), envir = phenology)
			
			}
#####################################################################
		if(f==4) {
	    	cat("4:  Introduce fixed parameters:\n")
			cat("    pfixed<-c(Flat=0, Min=0)\n")
			pfixed<-NULL
			cat("Do you want Flat parameter is fixed to 0: Y [Default]/N\n")
			ask <- scan(nmax=1, what="character", quiet=TRUE)
			if (ask=="") {ask <- "Y"}
			if (ask=="Y") {pfixed <-c(pfixed, Flat=0)}
			cat("Do you want Min parameter is fixed to 0: Y [Default]/N\n")
			ask <- scan(nmax=1, what="character", quiet=TRUE)
			if (ask=="") {ask <- "Y"}
			if (ask=="Y") {
				pfixed <-c(pfixed, Min=0)
			} else {
				cat("Do you want MinB parameter is fixed to 0: Y [Default]/N\n")
				ask <- scan(nmax=1, what="character", quiet=TRUE)
				if (ask=="") {ask <- "Y"}
				if (ask=="Y") {pfixed <-c(pfixed, MinB=0)}
				cat("Do you want MinE parameter is fixed to 0: Y [Default]/N\n")
				ask <- scan(nmax=1, what="character", quiet=TRUE)
				if (ask=="") {ask <- "Y"}
				if (ask=="Y") {pfixed <-c(pfixed, MinE=0)}
			}
			repeat {
				cat("Name of other parameter to change: Enter to end\n")
				ask <- scan(nmax=1, what="character", quiet=TRUE)
				if (ask=="") {break()}
				cat("Value for the parameter: Enter to end\n")
				vale <- scan(nmax=1, what="character", quiet=TRUE)
				if (vale=="") {break()}
				pfixed <-c(pfixed, assign(ask, as.numeric(vale)))			
			}
			
			assign(pfixed, pfixed, envir = phenology)

		}
#####################################################################
		if(f==5) {
			cat("5:  Estimate set of initial values:\n")
			cat("    Par<-par_init(data=Formated, parametersfixed=pfixed)\n")
			cat("Name of formated data: Formated [Default]\n")
			Formated <- scan(nmax=1, what="character", quiet=TRUE)
			if (Formated=="") {Formated <- "Formated"}
			cat("Name of the fixed parameters: pfixed [default]\n")
			pfixed <- scan(nmax=1, what="character", quiet=TRUE)
			if (pfixed=="") {pfixed <- "pfixed"}
			cat("Name of object to store parameters: Par [default]\n")
			Par <- scan(nmax=1, what="character", quiet=TRUE)
			if (Par=="") {Par <- "Par"}
			
			assign(Par, par_init(data=get(Formated, envir = phenology), parametersfixed=get(pfixed, envir = phenology)), envir = phenology)
			
		}
#####################################################################
		if(f==6) {
			cat("6:  Fit the phenology:\n")
			cat("    + result<-  fit_phenology(data = NULL, parametersfit = Par, parametersfixed = pfixed)\n")
			cat("Name of formated data: Formated [Default]\n")
			Formated <- scan(nmax=1, what="character", quiet=TRUE)
			if (Formated=="") {Formated <- "Formated"}
			cat("Name of the fixed parameters: pfixed [default]\n")
			pfixed <- scan(nmax=1, what="character", quiet=TRUE)
			if (pfixed=="") {pfixed <- "pfixed"}
			cat("Name of parameters: Par [default]\n")
			Par <- scan(nmax=1, what="character", quiet=TRUE)
			if (Par=="") {Par <- "Par"}
			cat("Name of object to store result: result [default]\n")
			result <- scan(nmax=1, what="character", quiet=TRUE)
			if (Par=="") {result <- "result"}

			assign(result, fit_phenology(data=get(Formated, envir = phenology), parametersfit = get(Par, envir = phenology), parametersfixed=get(pfixed, envir = phenology)), envir = phenology)

		}

#####################################################################
		if(f==8) {
			cat("8: para<-BE_to_LBLE(parameters=para)\n")
			cat("Parameters to be changed:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
					assign(p, BE_to_LBLE(parameters=eval(as.name(p))), envir = phenology)
					print("Done !")
				} else {
					print("The parameters do not exist.")
				}
			}
		}
#####################################################################
		if(f==9) {
			cat("9: para<-LBLE_to_BE(parameters=para)\n")
			cat("Parameters to be changed:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
					assign(p, LBLE_to_BE(parameters=eval(as.name(p))), envir = phenology)
					print("Done !")
				} else {
					print("The parameters do not exist.")
				}
			}
		}
#####################################################################
		if(f==12) {
			cat("12: para<-extract_result(result=res)\n")
			cat("Result data to be used:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
			 		cat("Parameters data to be setup:\n")
			 		q<-scan(nmax=1, what="character")
					if(length(q)!=0) {
						assign(q, extract_result(result=eval(as.name(p))), envir = phenology)
						print("Done !")
					}
				} else {
					print("The results do not exist.")
				}
			}
		}
#####################################################################
		if(f==13) {
			cat("13: para<-remove_site(parameters=para)\n")
			cat("Parameters to be changed:\n")
			p<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(p)!=0) {
				es<-try(eval(as.name(p)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
					assign(p, remove_site(parameters=eval(as.name(p))), envir = phenology)
					print("Done !")
				} else {
					print("The parameters do not exist.")
				}
			}
		}

#####################################################################
		if(f==14) {
			cat("14: parfixed<-add_SD(parametersfixed=NULL, parameters=name, SD=value)\n")
			cat("Fixed parameters to be changed:\n")
			pf<-scan(nmax=1, what="character", quiet=TRUE)
			if(length(pf)!=0) {
				es<-try(eval(as.name(pf)), silent=TRUE)
			 	if(substr(es[1], 1, 5)!="Error") {
			 		cat("The fixed parameters are:\n", sep=" ")
					cat(names(es), "\n", sep=" ")
					cat("Name of the parameter to add a SD value:\n")
					npf<-scan(nmax=1, what="character", quiet=TRUE)
					if(length(npf)!=0) {
			 			if(any(names(es)==npf)) {
			 				cat("SD value:\n")
			 				sd<-scan(nmax=1, what="numeric", quiet=TRUE)
							if(length(sd)!=0) {
								sd<-as.numeric(sd)
								es<-add_SD(parametersfixed=es, parameters=npf, SD=sd)
								assign("pf", es, envir = phenology)
								print("Done !")
							}
						} else {
							print("The parameter does not exist.")
						}
					}
				} else {
					print("The parameters list do not exist.")
				}
			}
		}

		

		
		
#####################################################################

	} else {
	break()
	}
	
	}

}
