% Generated by roxygen2 (4.0.2): do not edit by hand
\name{compassRose2}
\alias{compassRose2}
\title{Display a compass rose}
\usage{
compassRose2(x, y, rot = 0, cex = 1, col = "black",
  col.arrows.light = "white", col.arrows.dark = "black")
}
\arguments{
\item{x}{The position of the center of the compass rose in user units.}

\item{y}{The position of the center of the compass rose in user units.}

\item{rot}{Rotation for the compass rose in degrees. See Details.}

\item{cex}{The character expansion to use in the display.}

\item{col}{The color of text}

\item{col.arrows.light}{The color of lighter lines}

\item{col.arrows.dark}{The color of darker lines}
}
\value{
none
}
\description{
Displays a basic compass rose, usually to orient a map.
compassRose displays a conventional compass rose at the position requested.
The size of the compass rose is determined by the character expansion,
as the central "rose" is calculated relative to the character size.
Rotation is in degrees counterclockwise.
}
\details{
compassRose2 Display a compass rose
}
\examples{
\dontrun{
library("maps")
library("phenology")
map("world", "China")
compassRose2(x=110, y=35, col.arrows.light="grey")
}
}
\author{
modified from Jim Lemon; See compassRose {sp}
}

