% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.phenology.R
\name{plot.phenology}
\alias{plot.phenology}
\title{Plot the phenology from a result.}
\usage{
\method{plot}{phenology}(x, ..., series = "all", moon = FALSE,
  replicate.CI = 10000, resultmcmc = NULL, chain = 1,
  replicate.CI.mcmc = "all", level = 0.95,
  plot.objects = c("observations", "ML", "ML.SD", "ML.quantiles",
  "MCMC.quantiles"), col.ML = "black", col.SD = "red",
  col.MCMC.quantiles = "purple", col.ML.quantiles = "black",
  col.observations = "black", col.grouped.observations = "green")
}
\arguments{
\item{x}{A result file generated by fit_phenology}

\item{...}{Parameters used by plot}

\item{series}{Name or number of series to be plotted or 'all'}

\item{moon}{If TRUE, the moon phase is ploted. Default is FALSE}

\item{replicate.CI}{Number of replicates for estimation of confidence interval}

\item{resultmcmc}{A mcmc object}

\item{chain}{The number of chain to be used in resultmcmc}

\item{replicate.CI.mcmc}{Number of iterations to be used or "all"}

\item{level}{Level to estimate confidence interval or credibility interval}

\item{plot.objects}{What to plot?}

\item{col.ML}{Color of the ML mean curve}

\item{col.SD}{Color of the SD curve (distribution of observations)}

\item{col.MCMC.quantiles}{Color of the quantiles curve based on mcmc}

\item{col.ML.quantiles}{Color of the SE curve based on ML}

\item{col.observations}{Color of the points}

\item{col.grouped.observations}{Color of the lines indicating grouped observations}
}
\value{
A list with four objects: synthesis is a data.frame with global estimate of nesting.\cr
details_MCMC, details_ML and details_mean are lists with day by day information for each series.
}
\description{
The function plot.phenology plots the phenology graph from a result object.\cr
If cofactors have been added, the plot does not show their effects.\cr
plot.objects can be "observations", "ML" for maximum likelihood, "ML.SD" for dispersion of observations, "ML.quantiles" or "MCMC.quantiles" if a mcmc object is given
}
\details{
plot.phenology plots the phenology.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot <- read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name = "Complete", 
		reference = as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL, trace=1)
data(result_Gratiot)
# Plot the phenology and get some stats
output <- plot(result_Gratiot)
# Plot only part of the nesting season
ptoutput <- plot(result_Gratiot, xlim=c(as.Date("2001-03-01"),as.Date("2001-08-31")))
# Use month names in English
Sys.setlocale(category = "LC_TIME", locale = "en_GB.UTF-8")
output <- plot(result_Gratiot)
# set back the month name in local R language
Sys.setlocale(category = "LC_TIME", locale = "")
# plot based on quantiles of mcmc object
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "MCMC.quantiles"))
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "ML.SD", "ML.quantiles"))
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "ML.SD", "MCMC.quantiles"))
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "ML.quantiles", "MCMC.quantiles"))
}
}
\author{
Marc Girondot
}
