% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map}
\alias{map}
\title{Mean Arterial Pressure}
\usage{
map(sbp, dbp)
}
\arguments{
\item{sbp}{numeric vector, systolic blood pressure measured in mmHg}

\item{dbp}{numeric vector, diastolic blood pressure measured in mmHg}
}
\value{
a numeric vector
}
\description{
Estimate mean arterial pressure from systolic and diastolic blood pressures.
}
\details{
Mean Arterial Pressure is approximated by:
(DBP + (SBP - DBP) / 3) = (2/3) DBP + (1/3) SBP
}
\examples{

DF <- expand.grid(sbp = 40:130, dbp = 20:100)
DF$map <- with(DF, map(sbp, dbp))
with(DF, plot(sbp, dbp, col = map))
DF$map[DF$sbp < DF$dbp] <- NA

z <- matrix(DF$map, nrow = length(unique(DF$sbp)), ncol = length(unique(DF$dbp)))

image(
  x = unique(DF$sbp),
  y = unique(DF$dbp),
  z = z,
  col = hcl.colors(100, palette = "RdBu"),
  xlab = "SBP (mmHg)",
  ylab = "DBP (mmHg)",
  main = "Estimated Mean Arterial Pressue"
)
contour(x = unique(DF$sbp), y = unique(DF$dbp), z = z, add = TRUE)

}
