% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-csi-dat.r
\name{read_csi_dat}
\alias{read_csi_dat}
\title{Read '.DAT' file(s) saved by modern Campbell Scientific loggers.}
\usage{
read_csi_dat(file, geocode = NULL, label = NULL, data_skip = 0,
  n_max = Inf, locale = readr::default_locale())
}
\arguments{
\item{file}{Path to file as a character string.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{data_skip}{integer Number of records (rows) to skip from the actual
data block.}

\item{n_max}{integer Maximum number of records to read.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use 
\code{\link[readr]{locale}} to create your own locale that controls things 
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}
}
\value{
\code{read_csi_dat()} returns a \code{tibble::tibble} object.
}
\description{
Reads and parses the header of a processed data file as output by the PC400
or PC200W programmes extracting variable names, units and quantities from the
header. Uses the comment attribute to store the metadata.
}
\note{
This function is not useful for .DAT and .PRN files from old CSI
  loggers and software. Those were simple files, lacking metadata, which was
  stored in separate .FLD files.
}
\references{
\url{http://www.r4photobiology.info} \url{http://www.campbellsci.eu/}
}

