% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-fmi-cum.R
\name{read_fmi_cum}
\alias{read_fmi_cum}
\alias{read_m_fmi_cum}
\title{Read daily cummulated solar spectrum data file(s).}
\usage{
read_fmi_cum(file, date = NULL, geocode = NULL, label = NULL, tz = NULL,
  locale = readr::default_locale(), .skip = 3, .n_max = -1,
  .date.f = lubridate::ymd)

read_m_fmi_cum(files, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, .skip = 3, .n_max = -1, .date.f = lubridate::ymd)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data (either a
single string or a raw vector).}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in
file is used, and if \code{NA} no date variable is added}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the
file header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{.skip}{Number of lines to skip before reading data.}

\item{.n_max}{Maximum number of records to read.}

\item{.date.f}{A function for extracting a date-time from the file name
passed as charecter sring to its first argument and which returns a
\code{POSIXct} object.}

\item{files}{list or vector of paths each one with the same requirements as
described for argument \code{file}.}
}
\value{
\code{read_fmi_cum()} returns a \code{source_spct} object with
  \code{time.unit} attribute set to \code{"day"} and \code{when.measured}
  attribute set to the date-time extracted from the file name.

\code{read_m_fmi_cum} returns a collection of \code{source_mspct}.
}
\description{
Read one or more cumulated daily spectral irradiance file as output by Anders
Lindors' model based on libRadTrans. The file naming conventions needed
are fairly strict, and file name should contain the date in a format
suitable for decoding by the function suplied as \code{date.f}.
}
\note{
See \code{\link[readr]{read_table}} for details of acceptable values
 for \code{file}.
}

