% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-libradtran.r
\name{read_uvspec_disort_vesa}
\alias{read_uvspec_disort_vesa}
\title{Read libRadtran's uvspec output file from batch job.}
\usage{
read_uvspec_disort_vesa(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale(), multiplier = 1e-06,
  simplify = TRUE)
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object, but if \code{NULL} the date stored in
file is used, and if \code{NA} no date variable is added}

\item{geocode}{A data frame with columns \code{lon} and \code{lat}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is by default read from the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{multiplier}{numeric A multiplier for conversion into W m-2 nm-1, as
the units of expression of the output from "uvspec" depend on the units
in which the extraterrestrial solar spectrum data is expressed.}

\item{simplify}{logical Remove redundant columns from returned object.}
}
\value{
a source_spct object, possibly containing several spectra in long
 form and a datetime column.
}
\description{
Reads and parses the header and body of a text file output by a script used 
to run libRadtran's uvspec in a batch joib for a set of solar spectrum 
simulations. The header and time and date fields are converted into a 
datetime object.
}
\references{
\url{http://www.r4photobiology.info} \url{http://www.libradtran.org}
}

