% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-wrappers.r
\name{spct_CRI}
\alias{spct_CRI}
\title{Color reproduction index}
\usage{
spct_CRI(spct, adapt = TRUE, attach = FALSE, tol = 0.0054, named = FALSE)
}
\arguments{
\item{spct}{source_spct A single light source spectrum.}

\item{adapt}{logical If TRUE, then a special chromatic adaption is performed,
see Details in \code{\link[colorSpec]{computeCRI}}.}

\item{attach}{logical If TRUE, then a large list of intermediate calculations
is attached to the returned number, as attribute data. This attached list
includes data for all special 14 color samples, although the last 6 do not
affect the returned CRI}

\item{tol}{numeric For the CRI to be meaningful the chromaticities of the
test and reference illuminants must be sufficiently close in the CIE 1960
uniform chromaticity space. If the tolerance is exceeded, the function
returns NA. The default tol=5.4e-3 is the one recommended by the CIE, but
the argument allows the user to override it.}

\item{named}{logical Whether to set the name attribute of the returned
value to the name of the spectrum passed as argument if possible.}
}
\value{
A numeric value between zero and 100, or NA if the light is not
  white enough.
}
\description{
Wrapper on function \code{\link[colorSpec]{computeCRI}} from package
'colorSpec' that accepts \code{\link[photobiology]{source_spct}} objects.
}
\details{
Please see \code{\link[colorSpec]{computeCRI}} for the details of
  the computations and references.
}
\examples{

spct_CRI(white_led.source_spct)
spct_CRI(sun.spct)

}
