#' Spectral data for LED array from LUMITRONIX
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for a high power light emitting diode (LED) array from LUMITRONIX  based 
#' NICHIA's high efficiency natural white SMT LEDs. Specifications: LUMITRONIX 
#' SmartArray Q36 LED-Module, 4247 lm, 4000K, 39W electrical. Data are
#' normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'   
#' @examples 
#' lumitronix
#' 
#' @note
#' Lumitronix is a supplier of LED arrays, and a distributor of LEDs.
#' @references \url{http://www.leds.de/}
#' 
#' @seealso \code{\link{leds.mspct}}
#' 
#' @family manufacturers
#' 
"lumitronix"
