% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.r
\docType{data}
\name{incandescent_lamps}
\alias{incandescent_lamps}
\alias{types}
\alias{led_lamps}
\alias{mercury_lamps}
\alias{multimetal_lamps}
\alias{sodium_lamps}
\title{Spectral data for Lamps of different types}
\format{A vector of character strings.}
\usage{
incandescent_lamps

led_lamps

mercury_lamps

multimetal_lamps

sodium_lamps
}
\description{
Names of datasets containing the wavelengths and tabulated values spectral emittance 
for the lamps of different types.
}
\note{
In the case of LED-based lamps we include here only ready built commercially 
available lamps.
In some cases assembled from multiple descrete LEDs, possible of mixed types and 
spectral output. For emission spectra for LEDs available as electronic components
please see \code{\link[photobiologyLEDs]{photobiologyLEDs-package}}.
}
\examples{
sodium_lamps
multimetal_lamps
mercury_lamps
led_lamps

# select lamps emitting in the amber, yellow, orange region
lamps.mspct[sodium_lamps]

}
\seealso{
\code{\link{lamps.mspct}}
}
\keyword{datasets}
