% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_tools.R
\name{plot_BNPR}
\alias{plot_BNPR}
\title{Plot a BNPR output}
\usage{
plot_BNPR(BNPR_out, traj = NULL, xlim = NULL, ylim = NULL, nbreaks = 40,
  lty = 1, lwd = 2, col = "black", main = "", log = "y",
  ylab = "Effective Population Size", xlab = "Time", xmarline = 3,
  axlabs = NULL, traj_lty = 2, traj_lwd = 2, traj_col = col,
  newplot = TRUE, credible_region = TRUE, heatmaps = TRUE,
  heatmap_labels = TRUE, heatmap_labels_side = "right", heatmap_width = 7,
  yscale = 1, ...)
}
\arguments{
\item{BNPR_out}{output of BNPR or BNPR_PS.}

\item{traj}{function summarizing the true effective population size 
trajectory.}

\item{xlim}{numeric x-axis interval.}

\item{ylim}{numeric y-axis interval.}

\item{nbreaks}{integer number of bins for sampling heatmap.}

\item{lty}{line type for estimated trajectory.}

\item{lwd}{line width for estimated trajectory.}

\item{col}{color for estimated trajectory.}

\item{main}{character main plot title.}

\item{log}{character which axes to plot log-scale. Defaults to "y".}

\item{ylab}{character y-axis label.}

\item{xlab}{character x-axis label.}

\item{xmarline}{numeric if not using default x-axis labels, how far to put 
the labels from the axis.}

\item{axlabs}{character vector x-axis labels.}

\item{traj_lty, traj_lwd, traj_col}{line type, line width, and line color for 
the true trajectory.}

\item{newplot}{boolean whether to create a new plot or superimpose over a 
previously open plot.}

\item{credible_region}{logical whether to display pointwise credible region.}

\item{heatmaps}{boolean whether to display sampling and coalescent heatmaps.}

\item{heatmap_labels}{boolean whether to display labels on heatmaps.}

\item{heatmap_labels_side}{string which side of plot to display heatmaps.}

\item{heatmap_width}{numeric how wide heatmaps should be.}

\item{yscale}{numeric scaling applied to all effective population
calculations.}

\item{...}{additional arguments to be passed onto plot().}
}
\description{
Plot a BNPR output
}

