% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user-special.R
\name{plot_phylota_treemap}
\alias{plot_phylota_treemap}
\title{Plot treemap of Phylota object}
\usage{
plot_phylota_treemap(phylota, cids = NULL, txids = NULL, cnms = cids,
  txnms = txids, with_labels = TRUE, area = c("ntx", "nsq", "ncl"),
  fill = c("NULL", "typ", "ntx", "nsq", "ncl"))
}
\arguments{
\item{phylota}{Phylota object}

\item{cids}{Cluster IDs}

\item{txids}{Taxonomic IDs}

\item{cnms}{Cluster names}

\item{txnms}{Taxonomic names}

\item{with_labels}{Show names per box?}

\item{area}{What determines the size per box?}

\item{fill}{What determines the coloured fill per box?}
}
\value{
geom_object
}
\description{
Treemaps show relative size with boxes. The user can
explore which taxa or clusters are most represented either by
sequence or cluster number. If cluster IDs are provided, the plot
is made for clusters. If taxonomic IDs are provided, the plot is
made for taxa.
}
\details{
The function can take a long time to run for large Phylota
objects over many taxonomic IDs because searches are made across
lineages. The idea of the function is to assess the data dominance
of specific clusters and taxa.
}
\examples{
data("tinamous")
# Plot clusters, size by n. sq, fill by n. tx
p <- plot_phylota_treemap(phylota = tinamous, cids = tinamous@cids,
                          area = 'nsq', fill = 'ntx')
print(p)
# Plot taxa, size by n. sq, fill by ncl
txids <- get_txids(tinamous, txids = tinamous@txids, rnk = 'genus')
txids <- txids[txids !=  '']
txids <- unique(txids)
txnms <- get_tx_slot(tinamous, txids, slt_nm = 'scnm')
p <- plot_phylota_treemap(phylota = tinamous, txids = txids, txnms = txnms,
                          area = 'nsq', fill = 'ncl')
print(p)
}
\seealso{
Other tools-public: \code{\link{calc_mad}},
  \code{\link{calc_wrdfrq}}, \code{\link{drop_by_rank}},
  \code{\link{drop_clstrs}}, \code{\link{drop_sqs}},
  \code{\link{get_clstr_slot}}, \code{\link{get_nsqs}},
  \code{\link{get_ntaxa}}, \code{\link{get_sq_slot}},
  \code{\link{get_stage_times}}, \code{\link{get_tx_slot}},
  \code{\link{get_txids}}, \code{\link{is_txid_in_clstr}},
  \code{\link{is_txid_in_sq}},
  \code{\link{list_clstrrec_slots}},
  \code{\link{list_ncbi_ranks}},
  \code{\link{list_seqrec_slots}},
  \code{\link{list_taxrec_slots}},
  \code{\link{plot_phylota_pa}},
  \code{\link{read_phylota}}, \code{\link{write_sqs}}
}
