% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctl_pillar.R
\name{new_pillar}
\alias{new_pillar}
\title{Construct a custom pillar object}
\usage{
new_pillar(components, ..., width = NULL, class = NULL, extra = NULL)
}
\arguments{
\item{components}{A named list of components constructed with \code{\link[=pillar_component]{pillar_component()}}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{width}{Default width, optional.}

\item{class}{Name of subclass.}

\item{extra}{For compound pillars, indicate the names or indices of the
sub-pillars that could not be shown due to width constraints.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{new_pillar()} is the low-level constructor for pillar objects.
It supports arbitrary components.
See \code{\link[=pillar]{pillar()}} for the high-level constructor with default components.
}
\details{
Arbitrary components are supported.
If your tibble subclass needs more or different components in its pillars,
override or extend \code{\link[=ctl_new_pillar]{ctl_new_pillar()}} and perhaps \code{\link[=ctl_new_pillar_list]{ctl_new_pillar_list()}}.
}
\examples{
lines <- function(char = "-") {
  stopifnot(nchar(char) == 1)
  structure(char, class = "lines")
}

format.lines <- function(x, width, ...) {
  paste(rep(x, width), collapse = "")
}

new_pillar(list(
  title = pillar_component(new_ornament(c("abc", "de"), align = "right")),
  lines = new_pillar_component(list(lines("=")), width = 1)
))
}
