% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_board_registry.R
\name{board_register}
\alias{board_register}
\alias{board_register_rsconnect}
\alias{board_deregister}
\alias{board_default}
\alias{board_list}
\alias{board_get}
\title{Board registry (legacy API)}
\usage{
board_register(board, name = NULL, cache = NULL, versions = NULL, ...)

board_register_rsconnect(
  name = "rsconnect",
  server = NULL,
  account = NULL,
  key = NULL,
  output_files = FALSE,
  cache = NULL,
  ...
)

board_deregister(name, ...)

board_default()

board_list()

board_get(name)
}
\description{
The legacy pins API uses a board registry, where you first register a board
then refer to it by name in calls to pin functions.
}
\examples{
# legacy API
board_register_local("myboard", cache = tempfile())
pin(mtcars, board = "myboard")
pin_get("mtcars", board = "myboard")

# modern API (not available for all boards)
board <- board_temp()
board \%>\% pin_write(mtcars)
board \%>\% pin_read("mtcars")
}
\keyword{internal}
