% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_caption.R
\name{sprinkle_caption}
\alias{sprinkle_caption}
\alias{sprinkle_caption.default}
\alias{sprinkle_caption.dust_list}
\title{Change the Caption in a Dust Table}
\usage{
sprinkle_caption(x, caption, ...)

\method{sprinkle_caption}{default}(x, caption, ...)

\method{sprinkle_caption}{dust_list}(x, caption, ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{caption}{\code{character(1)} giving the new caption for the table.}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
The table caption is often used as a brief title, but may also 
  be used to provide a longer statement explaining how to interpret the 
  table results.
}
\details{
The caption may be set during the initial \code{dust} call.  This
  method allows for modification afterward, such as in the case of when a 
  \code{dust} object is loaded from memory and the initial call cannot be
  accessed.
}
\section{Functional Requirements}{

\enumerate{
 \item Change the \code{caption} attribute of the \code{dust} object.
 \item Cast an error if \code{x} is not a \code{dust} object.
 \item Cast an error if \code{caption} is not a character object.
 \item Cast an error if \code{caption} has length greater than 1.
}
}
\author{
Benjamin Nutter
}
\seealso{
\code{\link{dust}}, \code{\link{sprinkle}}
}

