\name{simulate.blim}
\alias{simulate.blim}
\title{Simulate Responses from Basic Local Independence Models (BLIMs)}
\description{
  Simulates responses from the distribution corresponding to a fitted
  \code{blim} model object.
}
\usage{
\method{simulate}{blim}(object, nsim = 1, seed = NULL, \dots)
}
\arguments{
  \item{object}{an object of class \code{blim}, typically the result of a
    call to \code{\link{blim}}.}
  \item{nsim}{currently not used.}
  \item{seed}{currently not used.}
  \item{\dots}{further arguments passed to or from other methods.
    None are used in this method.}
}
\details{
  Responses are simulated in two steps:  First, a knowledge state is drawn
  with probability \code{P.K}.  Second, responses are generated by applying
  \code{\link{rbinom}} with probabilities computed from the model
  object's \code{beta} and \code{eta} components.
}
\value{
  A named vector of frequencies of response patterns.
}
\seealso{
  \code{\link{blim}}.
}
\examples{
data(DoignonFalmagne7)
 
blim1 <- blim(DoignonFalmagne7$K, DoignonFalmagne7$N.R)

simulate(blim1)

## Parametric bootstrap
disc <- replicate(200, blim(blim1$K, simulate(blim1))$discrepancy)

hist(disc, col = "lightgray", border = "white", freq = FALSE, breaks = 20,
     main = "Parametric bootstrap", xlim = c(.05, .3))
abline(v = blim1$discrepancy, lty = 2)
}
\keyword{models}
