% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_landmarks.R
\name{landmarks_regradi}
\alias{landmarks_regradi}
\title{Pseudolandmarks with equally spaced angles}
\usage{
landmarks_regradi(
  x,
  n = 50,
  close = TRUE,
  plot = TRUE,
  ncol = NULL,
  nrow = NULL
)
}
\arguments{
\item{x}{A \code{matrix}, a \code{data.frame} a \code{list} of perimeter coordinates, often
produced with \code{\link[=object_contour]{object_contour()}}.}

\item{n}{Number of points to be sampled. Defaults to 50.}

\item{close}{Return a closed polygon? Defaults to \code{TRUE}.}

\item{plot}{Create a plot? Defaults to \code{TRUE}.}

\item{ncol, nrow}{The number of rows or columns in the plot grid when a \code{list}
is used in \code{x}. Defaults to \code{NULL}, i.e., a square grid is produced.}
}
\value{
A list with the following objects:
\itemize{
\item \code{pixindices}: Vector of radius indices.
\item \code{radii}: Vector of sampled radii lengths.
\item \code{Xc}: The centroid coordinate of \code{x} axis.
\item \code{Yc}: The centroid coordinate of \code{y} axis.
\item \code{coords}: Coordinates of sampled points arranged in a two-column matrix.
}

If \code{x} is a list, a list of objects described above is returned.
}
\description{
Select \code{n} landmarks that are spaced with a regular sequence of angles taken
between the outline coordinates and the centroid.
}
\note{
Borrowed from Claude (2008), pp. 53
}
\examples{
library(pliman)
plot_polygon(contours[[1]])
ldm <- landmarks_regradi(contours)

}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
