#' Master's students' employment condition
#'
#' `data.frame` with 3282 cross-sectional observations of 7 variables about 
#' employment condition of master's students one year after graduation. Data
#' refer to students graduated at the University of Trento (Italy) between 2009
#' and 2013.
#'
#' @name cross_1year
#' @docType data
#'
#' @format
#' `data.frame` with 3282 observations of 7 variables:
#' \describe{
#' \item{employment_sit:}{employment situation, a
#'   factor with three levels: *Employed*, *Unemployed*, *Trainee*.}
#' \item{gender:}{gender, a factor with two levels: *Male*, *Female*.}
#' \item{finalgrade:}{final grade degree, a factor with three levels:
#'   *Low*, *Average*, *High*.}
#' \item{duration:}{duration of studies, a factor with three levels:
#'   *Short*, *Average*, *Long*.}
#' \item{social_class:}{social class, a factor with five levels:
#'   *Working class*, *White-collar workers*, *Lower middle class*,
#'   *Upper middle class*, *Unclassified*.}
#' \item{irregularity:}{irregularity indicator of student's studies,
#'   a factor with three levels: *Low*, *Average*, *High*.}
#' \item{hsscore:}{high school final score, a numeric between 60 and
#'   100.}
#' }
#'
#' @references
#' \insertAllCited{}
#'
#' @keywords data
NULL


