% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shading_raster.R
\name{shading_raster}
\alias{shading_raster}
\title{Create a Shading Raster with a Palette}
\usage{
shading_raster(nr = NULL, nc = NULL, middle = NULL,
  palette = c("blue", "red"), mat = NULL, FUN = NULL)
}
\arguments{
\item{nr}{method 1 to use 
this function is to use \code{nr}, \code{nc}, 
\code{middle}. Suppose there is a matrix 
with \code{nr} rows and \code{nc} columns.
A cell whose position in the matrix is designated 
by \code{middle}. Then, this cell gets the first 
color of \code{palette}, and other cells get shading 
colors according to their distances between them 
and \code{middle}. Method 2 to use this 
function is to use \code{mat}. The biggest cell 
gets the first color and other cells get shading colors.}

\item{nc}{see \code{nr}.}

\item{middle}{see \code{nr}. The parameter 
should be a length 2 vector designating the 
row number and column number of a cell.}

\item{palette}{two or more colors used to make 
shading colors.}

\item{mat}{see \code{nr}.}

\item{FUN}{the default NULL makes the colors 
distributed in a linear way. However, \code{FUN}
can be a single parameter function which 
transforms the numeric values, such as 
\code{log}, \code{sqrt}.}
}
\description{
The function is a simple wrapper of 
\code{scales::col_numeric}.
The function creates a matrix of colors 
that can be used to draw a shading rectangle.
There are 2 ways to use the function, see 
the following parameters.
}
\examples{
# Use method 1.
r=shading_raster(nr=31, nc=60, middle=c(10, 55), 
	palette=c("darkorange", "red", "purple"))
ggplot()+xlim(0, 8)+ylim(0, 6)+
	annotation_raster(r, xmin=-Inf, xmax=Inf, 
	ymin=-Inf, ymax=Inf, interpolate=TRUE)
 # Use method 2.
r=matrix(c(
	1, 2, 3, 4, 5, 6, 7, 8, 
	1, 2, 3, 4, 5, 6, 7, 8, 
	1, 1, 1, 1, 1, 1, 1, 1), 
	nrow=3, byrow=TRUE)
r=shading_raster(mat=r, palette=c("green", "blue"))
}
