% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimplot.R
\name{DimPlot}
\alias{DimPlot}
\alias{FeatureDimPlot}
\title{DimPLot / FeatureDimPlot}
\usage{
DimPlot(
  data,
  dims = 1:2,
  group_by,
  group_by_sep = "_",
  split_by = NULL,
  split_by_sep = "_",
  pt_size = NULL,
  pt_alpha = 1,
  bg_color = "grey80",
  label_insitu = FALSE,
  show_stat = !identical(theme, "theme_blank"),
  label = FALSE,
  label_size = 4,
  label_fg = "white",
  label_bg = "black",
  label_bg_r = 0.1,
  label_repel = FALSE,
  label_repulsion = 20,
  label_pt_size = 1,
  label_pt_color = "black",
  label_segment_color = "black",
  highlight = NULL,
  highlight_alpha = 1,
  highlight_size = 1,
  highlight_color = "black",
  highlight_stroke = 0.8,
  add_mark = FALSE,
  mark_type = c("hull", "ellipse", "rect", "circle"),
  mark_expand = unit(3, "mm"),
  mark_alpha = 0.1,
  mark_linetype = 1,
  stat_by = NULL,
  stat_plot_type = c("pie", "ring", "bar", "line"),
  stat_plot_size = 0.1,
  stat_args = list(palette = "Set1"),
  graph = NULL,
  edge_size = c(0.05, 0.5),
  edge_alpha = 0.1,
  edge_color = "grey40",
  add_density = FALSE,
  density_color = "grey80",
  density_filled = FALSE,
  density_filled_palette = "Greys",
  density_filled_palcolor = NULL,
  lineages = NULL,
  lineages_trim = c(0.01, 0.99),
  lineages_span = 0.75,
  lineages_palette = "Dark2",
  lineages_palcolor = NULL,
  lineages_arrow = arrow(length = unit(0.1, "inches")),
  lineages_linewidth = 1,
  lineages_line_bg = "white",
  lineages_line_bg_stroke = 0.5,
  lineages_whiskers = FALSE,
  lineages_whiskers_linewidth = 0.5,
  lineages_whiskers_alpha = 0.5,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_nrow = NULL,
  facet_ncol = NULL,
  facet_byrow = TRUE,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  theme = "theme_this",
  theme_args = list(),
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  raster = NULL,
  raster_dpi = c(512, 512),
  hex = FALSE,
  hex_linewidth = 0.5,
  hex_count = TRUE,
  hex_bins = 50,
  hex_binwidth = NULL,
  palette = "Paired",
  palcolor = NULL,
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  ...
)

FeatureDimPlot(
  data,
  dims = 1:2,
  features,
  split_by = NULL,
  split_by_sep = "_",
  lower_quantile = 0,
  upper_quantile = 0.99,
  lower_cutoff = NULL,
  upper_cutoff = NULL,
  pt_size = NULL,
  pt_alpha = 1,
  bg_color = "grey80",
  bg_cutoff = NULL,
  label_insitu = FALSE,
  show_stat = !identical(theme, "theme_blank"),
  color_name = "",
  label = FALSE,
  label_size = 4,
  label_fg = "white",
  label_bg = "black",
  label_bg_r = 0.1,
  label_repel = FALSE,
  label_repulsion = 20,
  label_pt_size = 1,
  label_pt_color = "black",
  label_segment_color = "black",
  highlight = NULL,
  highlight_alpha = 1,
  highlight_size = 1,
  highlight_color = "black",
  highlight_stroke = 0.8,
  add_mark = FALSE,
  mark_type = c("hull", "ellipse", "rect", "circle"),
  mark_expand = unit(3, "mm"),
  mark_alpha = 0.1,
  mark_linetype = 1,
  stat_by = NULL,
  stat_plot_type = c("pie", "ring", "bar", "line"),
  stat_plot_size = 0.1,
  stat_args = list(palette = "Set1"),
  graph = NULL,
  edge_size = c(0.05, 0.5),
  edge_alpha = 0.1,
  edge_color = "grey40",
  add_density = FALSE,
  density_color = "grey80",
  density_filled = FALSE,
  density_filled_palette = "Greys",
  density_filled_palcolor = NULL,
  lineages = NULL,
  lineages_trim = c(0.01, 0.99),
  lineages_span = 0.75,
  lineages_palette = "Dark2",
  lineages_palcolor = NULL,
  lineages_arrow = arrow(length = unit(0.1, "inches")),
  lineages_linewidth = 1,
  lineages_line_bg = "white",
  lineages_line_bg_stroke = 0.5,
  lineages_whiskers = FALSE,
  lineages_whiskers_linewidth = 0.5,
  lineages_whiskers_alpha = 0.5,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_nrow = NULL,
  facet_ncol = NULL,
  facet_byrow = TRUE,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  theme = "theme_this",
  theme_args = list(),
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  raster = NULL,
  raster_dpi = c(512, 512),
  hex = FALSE,
  hex_linewidth = 0.5,
  hex_count = FALSE,
  hex_bins = 50,
  hex_binwidth = NULL,
  palette = "Spectral",
  palcolor = NULL,
  seed = 8525,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{dims}{A character vector of the column names to plot on the x and y axes or a numeric vector of the column indices.}

\item{group_by}{Columns to group the data for plotting
For those plotting functions that do not support multiple groups,
They will be concatenated into one column, using \code{group_by_sep} as the separator}

\item{group_by_sep}{The separator for multiple group_by columns. See \code{group_by}}

\item{split_by}{A character vector of column names to split the data and plot separately
If TRUE, we will split the data by the \code{features}. Each feature will be plotted separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{pt_size}{A numeric value of the point size. If NULL, the point size will be calculated based on the number of data points.}

\item{pt_alpha}{A numeric value of the point transparency. Default is 1.}

\item{bg_color}{A character string of the background or NA points. Default is "grey80".}

\item{label_insitu}{Whether to place the raw labels (group names) in the center of the points with the corresponding group. Default is FALSE, which using numbers instead of raw labels.}

\item{show_stat}{Whether to show the number of points in the subtitle. Default is TRUE.}

\item{label}{Whether to show the labels of groups. Default is FALSE.}

\item{label_size}{A numeric value of the label size. Default is 4.}

\item{label_fg}{A character string of the label foreground color. Default is "white".}

\item{label_bg}{A character string of the label background color. Default is "black".}

\item{label_bg_r}{A numeric value of the background ratio of the labels. Default is 0.1.}

\item{label_repel}{Whether to repel the labels. Default is FALSE.}

\item{label_repulsion}{A numeric value of the label repulsion. Default is 20.}

\item{label_pt_size}{A numeric value of the label point size. Default is 1.}

\item{label_pt_color}{A character string of the label point color. Default is "black".}

\item{label_segment_color}{A character string of the label segment color. Default is "black".}

\item{highlight}{A character vector of the row names to highlight. Default is NULL.}

\item{highlight_alpha}{A numeric value of the highlight transparency. Default is 1.}

\item{highlight_size}{A numeric value of the highlight size. Default is 1.}

\item{highlight_color}{A character string of the highlight color. Default is "black".}

\item{highlight_stroke}{A numeric value of the highlight stroke. Default is 0.5.}

\item{add_mark}{Whether to add mark to the plot. Default is FALSE.}

\item{mark_type}{A character string of the mark type. Default is "hull".}

\item{mark_expand}{A unit value of the mark expand. Default is 3mm.}

\item{mark_alpha}{A numeric value of the mark transparency. Default is 0.1.}

\item{mark_linetype}{A numeric value of the mark line type. Default is 1.}

\item{stat_by}{A character string of the column name to calculate the statistics. Default is NULL.}

\item{stat_plot_type}{A character string of the statistic plot type. Default is "pie".}

\item{stat_plot_size}{A numeric value of the statistic plot size. Default is 0.1.}

\item{stat_args}{A list of additional arguments to the statistic plot. Default is list(palette = "Set1").}

\item{graph}{A character string of column names or the indexes in the data for the graph data. Default is NULL.
If "@graph" is provided, the graph data will be extracted from the data attribute 'graph'.}

\item{edge_size}{A numeric vector of the edge size range. Default is c(0.05, 0.5).}

\item{edge_alpha}{A numeric value of the edge transparency. Default is 0.1.}

\item{edge_color}{A character string of the edge color. Default is "grey40".}

\item{add_density}{Whether to add density plot. Default is FALSE.}

\item{density_color}{A character string of the density color. Default is "grey80".}

\item{density_filled}{Whether to fill the density plot. Default is FALSE.}

\item{density_filled_palette}{A character string of the filled density palette. Default is "Greys".}

\item{density_filled_palcolor}{A character vector of the filled density palette colors. Default is NULL.}

\item{lineages}{A character vector of the column names for lineages. Default is NULL.}

\item{lineages_trim}{A numeric vector of the trim range for lineages. Default is c(0.01, 0.99).}

\item{lineages_span}{A numeric value of the lineages span. Default is 0.75.}

\item{lineages_palette}{A character string of the lineages palette. Default is "Dark2".}

\item{lineages_palcolor}{A character vector of the lineages palette colors. Default is NULL.}

\item{lineages_arrow}{An arrow object for the lineages. Default is arrow(length = unit(0.1, "inches")).}

\item{lineages_linewidth}{A numeric value of the lineages line width. Default is 1.}

\item{lineages_line_bg}{A character string of the lineages line background color. Default is "white".}

\item{lineages_line_bg_stroke}{A numeric value of the lineages line background stroke. Default is 0.5.}

\item{lineages_whiskers}{Whether to add whiskers to the lineages. Default is FALSE.}

\item{lineages_whiskers_linewidth}{A numeric value of the lineages whiskers line width. Default is 0.5.}

\item{lineages_whiskers_alpha}{A numeric value of the lineages whiskers transparency. Default is 0.5.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{raster}{Whether to raster the plot. Default is NULL.}

\item{raster_dpi}{A numeric vector of the raster dpi. Default is c(512, 512).}

\item{hex}{Whether to use hex plot. Default is FALSE.}

\item{hex_linewidth}{A numeric value of the hex line width. Default is 0.5.}

\item{hex_count}{Whether to count the hex.}

\item{hex_bins}{A numeric value of the hex bins. Default is 50.}

\item{hex_binwidth}{A numeric value of the hex bin width. Default is NULL.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{seed}{The random seed to use. Default is 8525.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{...}{Additional arguments.}

\item{features}{A character vector of the column names to plot as features.}

\item{lower_quantile, upper_quantile, lower_cutoff, upper_cutoff}{Vector of minimum and maximum cutoff values or quantile values for each feature.}

\item{bg_cutoff}{A numeric value to be used a cutoff to set the feature values to NA. Default is NULL.}

\item{color_name}{A character string of the color legend name. Default is "".}
}
\value{
A ggplot object or wrap_plots object or a list of ggplot objects

A ggplot object or wrap_plots object or a list of ggplot objects
}
\description{
Visualizing the dimension reduction data.
\code{FeatureDimPlot} is used to plot the feature numeric values on the dimension reduction plot.
}
\examples{
\donttest{
# generate a PCA dimension data for DimPlot
set.seed(8525)
df <- matrix(c(rnorm(333), rnorm(334, 0.2), rnorm(333, .4)), ncol = 10)
# run PCA
pca <- prcomp(df)
# get coordinates
data <- pca$x[, 1:2]
# kmeans clustering
km <- kmeans(data, 3)
data <- as.data.frame(data)
data$cluster <- factor(paste0("C", km$cluster))
data$group <- sample(c("A", "B"), nrow(data), replace = TRUE)

graph <- rnorm(nrow(data) * nrow(data))
graph[sample(1:(nrow(data) * nrow(data)), 5000)] <- NA
graph <- matrix(graph, nrow = nrow(data))
rownames(graph) <- colnames(graph) <- rownames(data)

attr(data, "graph") <- graph

data$L1 <- rnorm(nrow(data), 0, 0.1)
data$L2 <- rnorm(nrow(data), 1, 0.2)
data$L3 <- rnorm(nrow(data), 2, 0.3)

DimPlot(data, group_by = "cluster")
DimPlot(data, group_by = "cluster", theme = "theme_blank")
DimPlot(data, group_by = "cluster", theme = ggplot2::theme_classic,
        theme_args = list(base_size = 16), palette = "seurat")
DimPlot(data, group_by = "cluster", raster = TRUE, raster_dpi = 30)
DimPlot(data, group_by = "cluster", highlight = 1:20,
        highlight_color = "red2", highlight_stroke = 0.8)
DimPlot(data, group_by = "cluster", highlight = TRUE, facet_by = "group",
        theme = "theme_blank")
DimPlot(data, group_by = "cluster", label = TRUE)
DimPlot(data, group_by = "cluster", label = TRUE, label_fg = "red",
        label_bg = "yellow", label_size = 5)
DimPlot(data, group_by = "cluster", label = TRUE, label_insitu = TRUE)
DimPlot(data, group_by = "cluster", add_mark = TRUE)
DimPlot(data, group_by = "cluster", add_mark = TRUE, mark_linetype = 2)
DimPlot(data, group_by = "cluster", add_mark = TRUE, mark_type = "ellipse")
DimPlot(data, group_by = "cluster", add_density = TRUE)
DimPlot(data, group_by = "cluster", add_density = TRUE, density_filled = TRUE)
DimPlot(data, group_by = "cluster", add_density = TRUE, density_filled = TRUE,
        density_filled_palette = "Blues", highlight = TRUE)
DimPlot(data, group_by = "cluster", stat_by = "group")
DimPlot(data, group_by = "cluster", stat_by = "group", stat_plot_type = "bar")
DimPlot(data, group_by = "cluster", hex = TRUE)
DimPlot(data, group_by = "cluster", hex = TRUE, hex_bins = 20)
DimPlot(data, group_by = "cluster", hex = TRUE, hex_count = FALSE)
DimPlot(data, group_by = "cluster", graph = "@graph", edge_color = "grey80")
DimPlot(data, group_by = "cluster", lineages = c("L1", "L2", "L3"))
DimPlot(data, group_by = "cluster", lineages = c("L1", "L2", "L3"),
        lineages_whiskers = TRUE)
DimPlot(data, group_by = "cluster", lineages = c("L1", "L2", "L3"),
        lineages_span = 1)
DimPlot(data, group_by = "cluster",  split_by = "cluster",
        palcolor = list(C1 = "red", C2 = "blue", C3 = "green"))
}
\donttest{
# Feature Dim Plot
FeatureDimPlot(data, features = "L1", pt_size = 2)
FeatureDimPlot(data, features = "L1", pt_size = 2, bg_cutoff = -Inf)
FeatureDimPlot(data, features = "L1", raster = TRUE, raster_dpi = 30)
FeatureDimPlot(data, features = c("L1", "L2"), pt_size = 2)
FeatureDimPlot(data, features = c("L1"), pt_size = 2, facet_by = "group")
# Can't facet multiple features
FeatureDimPlot(data, features = c("L1", "L2", "L3"), pt_size = 2)
# We can use split_by
FeatureDimPlot(data, features = c("L1", "L2", "L3"), split_by = "group", nrow = 2)
FeatureDimPlot(data, features = c("L1", "L2", "L3"), highlight = TRUE)
FeatureDimPlot(data, features = c("L1", "L2", "L3"), hex = TRUE, hex_bins = 15)
FeatureDimPlot(data, features = c("L1", "L2", "L3"), hex = TRUE, hex_bins = 15,
  split_by = "cluster", palette = list(C1 = "Reds", C2 = "Blues", C3 = "Greens"))
}
}
