% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_func.R
\name{biplot.plsr}
\alias{biplot.plsr}
\title{Biplot for plsr Objects}
\usage{
\method{biplot}{plsr}(x, side = "X", LVs = c(1, 2), ...)
}
\arguments{
\item{x}{The plsr object}

\item{side}{The side for which the biplot should be generated. Can be "X" (default) to generate
a biplot of the loadings of X onto the latent space or "Y" for the loadings of Y.}

\item{LVs}{Vector of length two which specifies the latent variables to be plotted against each other.
For example, the default LVs=c(1,2) will plot latent variable 1 against latent variable 2.}

\item{...}{optional arguments to be passed to biplot.default.}
}
\description{
Produces a biplot from a plsr object
}
\examples{
plsr_obj = pls(rating_data,tracking_data,10,10)
biplot(plsr_obj)
\donttest{
biplot(plsr_obj, LV=c(2,3), side="Y")
}
}
