% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_func.R
\name{plot_perm_results}
\alias{plot_perm_results}
\title{Plot permuation results for plsr object}
\usage{
plot_perm_results(plsr_obj, ..., alpha = NULL,
  main = "Permutation Testing Results", lwd = 2, col = "red")
}
\arguments{
\item{plsr_obj}{A plsr_obj.}

\item{...}{Additional arguments passed to \code{barplot}.}

\item{alpha}{The significance threshold used. Will be indicated in the plot by a horizontal line.
If NULL (default), the alpha value of the plsr object will be used.}

\item{main}{The title of the plot.}

\item{lwd}{The line width of the line indicating alpha.}

\item{col}{The color of the line indicating alpha.}
}
\description{
Plots the p-values for the latent variables estimated through permutation testing.
}
\examples{
plsr_obj = pls(rating_data,tracking_data,10,10)
plot_perm_results(plsr_obj)
\donttest{
#plot with 0.10 as the significance threshold instead of the one specified by the plsr object
#and a thicker blue-colored line to indicate it
plot_perm_results(plsr_obj,lwd=5,col="blue", alpha=0.10)
}
}
