% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_cal.R
\name{glm_cal}
\alias{glm_cal}
\title{fits a calibration curve via glm or Cox proportional hazards model}
\usage{
glm_cal(
  y,
  p,
  x,
  xp,
  smooth,
  time = NULL,
  save_data = TRUE,
  save_mod = TRUE,
  pw = FALSE,
  ...
)
}
\arguments{
\item{y}{binary or a time-to-event (\code{Surv}) outcome. Former is fit via \code{glm} and latter is fit via \code{survival::coxph}.}

\item{p}{predicted probabilities}

\item{x}{predictor (could be transformation of \code{p})}

\item{xp}{values for plotting (same scale as \code{x})}

\item{smooth}{'rcs', 'ns', 'bs', or 'none'}

\item{time}{time to calculate survival probabilities at (only relevant if \code{y} is a \code{Surv} object)}

\item{save_data}{whether to save the data elements in the returned object}

\item{save_mod}{whether to save the model in the returned object}

\item{pw}{save pointwise standard errors for plotting}
}
\value{
list of class \code{glm_cal}
}
\description{
fits a calibration curve via glm or Cox proportional hazards model
}
\examples{
library(pmcalibration)
# simulate some data
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)

# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

glm_cal(y = dat$y, p = p, x = p, xp = NULL, smooth="ns", df=5)
}
\keyword{internal}
