% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_pressure.R
\name{metar_pressure}
\alias{metar_pressure}
\title{Get atmospheric pressure.}
\usage{
metar_pressure(x, altimeter = FALSE)
}
\arguments{
\item{x}{character vector; a METAR weather report or reports.}

\item{altimeter}{boolean; if TRUE pressure is returned in inHg (inch of mercury),
for the default value of FALSE in hPa.}
}
\value{
a numeric vector with air pressure in inHg or hPa.
}
\description{
Extract and parse an air pressure value from METAR weather report.
}
\examples{
metar_pressure("EPWA 281830Z 18009KT 140V200 9999 SCT037 03/M01 Q1008 NOSIG")
metar_pressure("CYUL 281800Z 13008KT 30SM BKN240 01/M06 A3005", altimeter = TRUE)
metar_pressure("201711271930 METAR LEMD 271930Z 02002KT CAVOK 04/M03 Q1025 NOSIG= NOSIG=")

}
