% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.multinom.R
\name{pmml.multinom}
\alias{pmml.multinom}
\title{Generate the PMML representation for a multinom object from package
\pkg{nnet}.}
\usage{
\method{pmml}{multinom}(
  model,
  model_name = "multinom_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "Multinomial Logistic Model",
  copyright = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  ...
)
}
\arguments{
\item{model}{A multinom object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the \code{multinom} object.
}
\description{
Generate the multinomial logistic model in the PMML
RegressionModel format.  The function implements the use of numerical,
categorical and multiplicative terms involving both numerical and
categorical variables.
}
\references{
\href{https://CRAN.R-project.org/package=nnet}{nnet: Feed-forward
Neural Networks and Multinomial Log-Linear Models (on CRAN)}
}
\author{
Tridivesh Jena
}
