% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.ksvm.R
\name{pmml.ksvm}
\alias{pmml.ksvm}
\title{Generate the PMML representation for a ksvm object from the package
\pkg{kernlab}.}
\usage{
\method{pmml}{ksvm}(
  model,
  model_name = "SVM_model",
  app_name = "SoftwareAG PMML Generator",
  description = "Support Vector Machine Model",
  copyright = NULL,
  model_version = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  dataset = NULL,
  ...
)
}
\arguments{
\item{model}{A ksvm object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{model_version}{A string specifying the model version.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{dataset}{Data used to train the ksvm model.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the ksvm object.
}
\description{
Generate the PMML representation for a ksvm object from the package
\pkg{kernlab}.
}
\details{
Both classification (multi-class and binary) as well as regression cases are
supported.

The following ksvm kernels are currently supported: rbfdot, polydot,
vanilladot, tanhdot.

The argument \code{dataset} is required since the \code{ksvm} object does not
contain information about the used categorical variable.
}
\examples{
# Train a support vector machine to perform classification.
library(kernlab)

model <- ksvm(Species ~ ., data = iris)

model_pmml <- pmml(model, dataset = iris)
}
\references{
\href{https://CRAN.R-project.org/package=kernlab}{kernlab: Kernel-based
Machine Learning Lab (on CRAN)}
}
