% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_auc.R
\name{get_auc}
\alias{get_auc}
\title{Calculate the area under the curve (AUC) for each subject over the time interval for dependent variables (\code{dv}) using the trapezoidal rule.}
\usage{
get_auc(data, time = "TIME", id = "ID", dv = "DV")
}
\arguments{
\item{data}{A data frame.}

\item{time}{A string containing the name of the chronologically ordered time variable in \code{data}.}

\item{id}{A string containing the name of the ID column (defining subject level data) in \code{data}.}

\item{dv}{A string containing the name of the dependent variable column in \code{data}.}
}
\value{
A data frame containing one AUC value for every subject as defined by \code{id}.

Based on the \code{AUC} function originally written by Leonid Gibiansky in package MIfuns 5.1, from Metrum Institute.
}
\description{
Calculate the area under the curve (AUC) for each subject over the time interval for dependent variables (\code{dv}) using the trapezoidal rule.
}
\examples{
\dontrun{
 AUCs <- get_auc(myAUCdata)
}

}
\references{
\url{https://code.google.com/archive/p/mifuns/}
}
\author{
Leonid Gibiansky, \email{lgibiansky@quantpharm.com}
}
