% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispersalFriction.R
\name{DispersalFriction}
\alias{DispersalFriction}
\title{R6 class representing a dispersal friction.}
\description{
\code{\link[R6:R6Class]{R6}} class functionality for modeling sea, ice and other
frictional barriers to dispersal within a spatially-explicit population model. The
dispersal friction model utilizes the
\code{\link[gdistance:gdistance]{gdistance}} package functionality to
calculate distance multipliers to modify distance-based dispersal rates for
simulated migrations in a spatio-temporal frictional landscape. The frictional
landscape is defined via conductance/permeability values, the inverse of friction,
which ranges from zero (barrier) to one (no friction) with values in-between
representing some friction. For example, a conductance value of 1/5 = 0.2 represents
a landscape in which simulated animals move 5 times slower than a non-friction
landscape. In this example the resultant distance multiplier would be 5, thus
reducing the effective dispersal range.
}
\examples{
#' U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster #' full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA #' make U Island
region <- Region$new(template_raster = template_raster)
raster::plot(region$region_raster, main = "Example region (indices)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")

#' Dispersal distances
dispersal_gen <- DispersalGenerator$new(region = region)
dispersal_gen$set_attributes(params = list(p = 0.5, b = 700, r = 3000))
distances <- round(dispersal_gen$calculate_distance_matrix()) #' in m
dispersal_gen$calculate_distance_data()
dispersal_indices <- as.matrix(dispersal_gen$distance_data$base[,1:2])

#' Distance multipliers with friction in cell 4
dispersal_friction <- DispersalFriction$new(region = region,
                                            conductance = c(1, 1, 1, 0.5, 1, 1, 1))
multipliers <- dispersal_friction$calculate_distance_multipliers(dispersal_indices)
cbind(dispersal_indices, distance = distances[dispersal_indices],
      multiplier = multipliers[[1]])

#' Note that crossing the water is avoided.

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{DispersalFriction}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{parallel_cores}}{Number of cores for running the simulations in parallel.}

\item{\code{write_to_dir}}{Directory path for storing distance multipliers when memory performance is an issue.}

\item{\code{transition_directions}}{Number of transition directions or neighbors in which cells are connected: usually 4, 8 (default), or 16 (see \code{\link[gdistance:transition]{gdistance::transition}}).}

\item{\code{conductance}}{Matrix/raster of conductance (inverse friction) values (range: 0 = barrier; 0 < some friction < 1; 1 = no friction) for each grid cell (rows/cells) at each simulation time step (columns/layers).}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-calculate_distance_multipliers}{\code{DispersalFriction$calculate_distance_multipliers()}}
\item \href{#method-clone}{\code{DispersalFriction$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute">}\href{../../poems/html/GenericModel.html#method-get_attribute}{\code{poems::GenericModel$get_attribute()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases">}\href{../../poems/html/GenericModel.html#method-get_attribute_aliases}{\code{poems::GenericModel$get_attribute_aliases()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_names">}\href{../../poems/html/GenericModel.html#method-get_attribute_names}{\code{poems::GenericModel$get_attribute_names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attributes">}\href{../../poems/html/GenericModel.html#method-get_attributes}{\code{poems::GenericModel$get_attributes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="set_attributes">}\href{../../poems/html/GenericModel.html#method-set_attributes}{\code{poems::GenericModel$set_attributes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SpatialModel" data-id="initialize">}\href{../../poems/html/SpatialModel.html#method-initialize}{\code{poems::SpatialModel$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="poems" data-topic="SpatialModel" data-id="new_clone">}\href{../../poems/html/SpatialModel.html#method-new_clone}{\code{poems::SpatialModel$new_clone()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-calculate_distance_multipliers"></a>}}
\if{latex}{\out{\hypertarget{method-calculate_distance_multipliers}{}}}
\subsection{Method \code{calculate_distance_multipliers()}}{
Calculates and returns spatio-temporal dispersal distance multipliers for each in-range migration.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalFriction$calculate_distance_multipliers(dispersal_indices, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dispersal_indices}}{Two-column matrix representing the target and source coordinate index for each in-range migration.}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Temporal list of dispersal distance multiplier arrays with values for each in-range migration.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalFriction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
