% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenericClass.R
\name{GenericClass}
\alias{GenericClass}
\title{R6 class with generic reusable functionality}
\description{
\code{\link[R6:R6Class]{R6}} class with generic (abstract) new cloning functionality.
}
\examples{
object1 <- GenericClass$new()
class(object1)
# Referencing
object_ref <- object1
object_ref$attached$a <- 1
object1$attached
# Cloning
object2 <- object1$clone()
object2$attached$b <- 2
object1$attached
object2$attached
# New cloning
object3 <- object1$new_clone()
object3$attached$c <- 3
object1$attached
object3$attached

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{object_generator}}{Class object generator used to create new clones, particularly for user inheritance.}

\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{GenericClass$new()}}
\item \href{#method-new_clone}{\code{GenericClass$new_clone()}}
\item \href{#method-clone}{\code{GenericClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialization method saves an object generator for new cloning.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericClass$new(object_generator = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object_generator}}{Class object generator used to create new clones, particularly for user inheritance.}

\item{\code{...}}{Parameters passed individually (ignored).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new_clone"></a>}}
\if{latex}{\out{\hypertarget{method-new_clone}{}}}
\subsection{Method \code{new_clone()}}{
Creates a new (re-initialized) object of the current (inherited) object class with optionally passed parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericClass$new_clone(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed via the inherited class constructor (defined in initialize and run via new).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New object of the current (inherited) class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GenericClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
