% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.plot.R
\name{event.plot}
\alias{event.plot}
\title{Plot event years for individual trees}
\usage{
event.plot(list.name, start.yr = NULL, end.yr = NULL,
           x.tick.major = 10, x.tick.minor = 5)
}
\arguments{
\item{list.name}{a \code{list} as produced by \code{\link{pointer.norm}} or \code{\link{pointer.rgc}}}

\item{start.yr}{an \code{integer} specifying the first year to be plotted. Defaults to the first year with data if \code{\var{start.yr}} is \code{NULL}.}

\item{end.yr}{an \code{integer} specifying the last year to be plotted. Defaults to the last year with data if \code{\var{end.yr}} is \code{NULL}.}

\item{x.tick.major}{an \code{integer} controlling the major x-axis tick labels. Defaults to 10 years.}

\item{x.tick.minor}{an \code{integer} controlling the minor x-axis ticks. Defaults to 5 years.}
}
\value{
Dot plot.
}
\description{
The function creates a dot plot showing positive and negative event year values from a \code{list} of the type as produced by \code{\link{pointer.norm}} or \code{\link{pointer.rgc}}.
}
\details{
The function makes a dot plot showing event years for individual trees. Positive and negative event years are indicated with different symbols. If event years were defined using \code{method.thresh "Neuwirth"} (\code{\link{pointer.norm}}), different tones of gray indicate weak, strong and extreme event years.

Non-event years are indicated with minus-signs, allowing the assessment of individual series length.
}
\examples{
## Plot event years for individual trees as generated using pointer.rgc
data(s033)
py <- pointer.rgc(s033, nb.yrs = 4, rgc.thresh.pos = 60, rgc.thresh.neg = 40, 
                  series.thresh = 75)
event.plot(py, start.yr = 1950, end.yr = NULL,
           x.tick.major = 10, x.tick.minor = 5) 

## Plot event years for individual trees as generated using pointer.norm (method "Neuwirth")
data(s033)
py_n <- pointer.norm(s033, window = 5, method.thresh = "Neuwirth",
                     series.thresh = 75)
event.plot(py_n, start.yr = 1950, end.yr = NULL,
           x.tick.major = 10, x.tick.minor = 5) 
           
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}

