% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_json_path_match}
\alias{ExprStr_json_path_match}
\alias{expr_json_path_match}
\title{json_path_match}
\arguments{
\item{json_path}{A valid JSON path query string.}
}
\value{
Utf8 array. Contain null if original value is null or the json_path return nothing.
}
\description{
Extract the first match of json string with provided JSONPath expression.
}
\details{
Throw errors if encounter invalid json strings.
All return value will be casted to Utf8 regardless of the original value.
Documentation on JSONPath standard can be found
\verb{here <https://goessner.net/articles/JsonPath/>}_.
}
\examples{
df = pl$DataFrame(
  json_val = c('{"a":"1"}', NA, '{"a":2}', '{"a":2.1}', '{"a":true}')
)
df$select(pl$col("json_val")$str$json_path_match("$.a"))
}
\keyword{ExprStr}
