% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_cummin}
\alias{Expr_cummin}
\alias{cummin}
\alias{Expr_cummax}
\title{Cumulative minimum}
\usage{
Expr_cummin(reverse = FALSE)

Expr_cummax(reverse = FALSE)
}
\arguments{
\item{reverse}{bool, default FALSE, if true roll over vector from back to forth}
}
\value{
Expr

Expr
}
\description{
Get an array with the cumulative min computed at every element.

Get an array with the cumulative max computed at every element.
}
\details{
Dtypes in {Int8, UInt8, Int16, UInt16} are cast to
Int64 before summing to prevent overflow issues.

See Inf,NaN,NULL,Null/NA translations here \code{\link[polars]{docs_translations}}

Dtypes in {Int8, UInt8, Int16, UInt16} are cast to
Int64 before summing to prevent overflow issues.

See Inf,NaN,NULL,Null/NA translations here \code{\link[polars]{docs_translations}}
}
\examples{
pl$DataFrame(list(a = 1:4))$select(
  pl$col("a")$cummin()$alias("cummin"),
  pl$col("a")$cummin(reverse = TRUE)$alias("cummin_reversed")
)
pl$DataFrame(list(a = 1:4))$select(
  pl$col("a")$cummax()$alias("cummux"),
  pl$col("a")$cummax(reverse = TRUE)$alias("cummax_reversed")
)
}
\keyword{Expr}
