% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polished_config.R
\name{polished_config}
\alias{polished_config}
\alias{global_sessions_config}
\title{global configuration for \code{polished} authentication}
\usage{
polished_config(
  app_name,
  api_key = get_api_key(),
  firebase_config = NULL,
  is_invite_required = TRUE,
  sign_in_providers = "email",
  is_email_verification_required = TRUE,
  cookie_expires = 365L,
  is_auth_required = TRUE,
  is_two_fa_required = FALSE
)

global_sessions_config(...)
}
\arguments{
\item{app_name}{the name of the Shiny app.}

\item{api_key}{the \code{polished} API key, available at \url{https://dashboard.polished.tech}.}

\item{firebase_config}{if using Social Sign In (see \url{https://polished.tech/docs/03-social-sign-in}
for more documentation), a list containing your Firebase project configuration (Default: \code{NULL}).
This list should have the following named elements:
\itemize{
\item{\code{apiKey}}
\item{\code{authDomain}}
\item{\code{projectId}}
}}

\item{is_invite_required}{\code{TRUE} by default.  Whether or not to require the user to have an
invite before registering/signing in}

\item{sign_in_providers}{a character vector of sign in providers to enable. Valid values are \code{"google"}
\code{"email"}, \code{"microsoft"}, and/or \code{"facebook"}. Defaults to \code{"email"}.}

\item{is_email_verification_required}{\code{TRUE} by default.  Whether or not to require the user to
verify their email before accessing your Shiny app.}

\item{cookie_expires}{the number of days before a user's cookie expires.
Set to \code{NULL} to force Sign Out at session end. This argument is passed to
the \code{expires} option in js-cookie: \url{https://github.com/js-cookie/js-cookie#expires}.
Default value is \code{365L} (i.e. 1 year)}

\item{is_auth_required}{\code{TRUE} by default.  Whether or not to require users to be signed
in to access the app.  It can be useful to set this argument to \code{FALSE} if you want to
allow users to do certain actions (such as viewing charts and tables) without signing in,
and only require users to sign in if they want to save data to your database.}

\item{is_two_fa_required}{boolean specifying whether or not 2 factor authentication is required.  Defaults
to \code{FALSE}.}

\item{...}{arguments to pass to \code{\link{polished_config}}}
}
\description{
global configuration for \code{polished} authentication
}
\details{
This is the primary function for configuring \code{polished}.  It configures your app's instance of
the \code{Polished} class that manages \code{polished} authentication.  Call this function in
your \code{global.R} file.  See \url{https://github.com/Tychobra/polished/blob/master/inst/examples/polished_example_01/global.R}
for a complete example.
}
\examples{

\dontrun{
# global.R

polished_config(
  app_name = "<your app name>",
  api_key = "<your API key>",
  firebase_config = list(
    apiKey = "<Firebase apiKey>",
    authDomain = "<Firebase authDomain",
    projectId = "<Firebase projectId>"
  ),
  sign_in_providers = c(
    "email",
    "google",
    "microsoft"
  )
)

}

}
