% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign_in_ui_default.R
\name{sign_in_ui_default}
\alias{sign_in_ui_default}
\title{Default UI styles for the Sign In & Registration pages}
\usage{
sign_in_ui_default(
  sign_in_module = sign_in_module_ui("sign_in"),
  color = "#5ec7dd",
  company_name = "Your Brand Here",
  logo_top = tags$div(style = "width: 300px; max-width: 100\%; color: #FFF;", class =
    "text-center", h1("Your", style = "margin-bottom: 0; margin-top: 30px;"), h1("Brand",
    style = "margin-bottom: 0; margin-top: 10px;"), h1("Here", style =
    "margin-bottom: 15px; margin-top: 10px;")),
  logo_bottom = NULL,
  icon_href = "polish/images/polished_icon.png",
  background_image = NULL,
  terms_and_privacy_footer = NULL,
  align = "center",
  button_color = NULL,
  footer_color = "#FFF"
)
}
\arguments{
\item{sign_in_module}{UI module for the Sign In & Registration pages.}

\item{color}{hex color for the background and button.}

\item{company_name}{your company name.}

\item{logo_top}{HTML for logo to go above the sign in panel.}

\item{logo_bottom}{HTML for the logo below the sign in panel.}

\item{icon_href}{the URL/path to the browser tab icon.}

\item{background_image}{the URL/path to a full width background image.  If set to \code{NULL},
the default, the \code{color} argument will be used for the background instead of this
image.}

\item{terms_and_privacy_footer}{links to place in the footer, directly above the copyright
notice.}

\item{align}{The horizontal alignment of the Sign In box. Defaults to \code{"center"}. Valid
values are \code{"left"}, \code{"center"}, or \code{"right"}}

\item{button_color}{the color of the "Continue", "Sign In", and "Register" buttons.  If kept
as \code{NULL}, the default, then the button color will be the same color as the color passed to
the \code{color} argument.}

\item{footer_color}{the text color for the copyright text in the footer.}
}
\value{
the UI for the Sign In & Registration pages
}
\description{
Default styling for the sign in & registration pages.  Update the \code{sign_in_ui_default()}
arguments with your brand and colors to quickly style the sign in & registration
pages to match your brand.
}
