% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{popsReads}
\alias{popsReads}
\title{Simulate total number of reads for multiple populations}
\usage{
popsReads(list_np, coverage, pError)
}
\arguments{
\item{list_np}{is a list where each entry corresponds to a different
population. Each entry is a vector and each vector entry contains the
number of diploid individuals of a given pool. Thus, if a population was
sequenced using two pools, each with 10 individuals, this vector would
contain two entries and both will be 10.}

\item{coverage}{a matrix containing the total depth of coverage of all
populations. Each row corresponds to a different population and each column
to a different site.}

\item{pError}{an integer representing the value of the error associated with
DNA pooling. This value is related with the unequal contribution of both
individuals and pools towards the total number of reads observed for a
given population - the higher the value the more unequal are the individual
and pool contributions.}
}
\value{
a list with one entry per population. Each entry represents the
number of reads contributed by each individual towards the total coverage
of its population. Different individuals correspond to different rows and
different sites to different columns.
}
\description{
Simulates the contribution of each individual towards the total coverage of
its population.
}
\details{
If multiple pools were used to sequence a population, this will compute the
contribution of each pool and then use that to calculate how many reads does
that pool contribute. Next, the probability of contribution of each
individual is computed and utilized to calculate the number of reads that
each individual contributes towards the total number of reads observed in the
corresponding pool. These steps will be performed for each population, thus
obtaining the number of reads contributed by each individual for each
population.
}
\examples{
# simulate coverage for two populations sequenced at 10x at 5 sites
reads <- simulateCoverage(mean = c(10, 10), variance = c(20, 20), nSNPs = 5, nLoci = 1)

# simulate the individual contribution towards that coverage
# assuming that the first population was sequenced using two pools of 5 individuals
# and the second using a single pool with 10 individuals
popsReads(list_np = list(c(5, 5), 10), coverage = reads, pError = 5)

}
